/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class DDD {
    private static long timeCheck;

    public static void dumpHex(String pFileName) throws IOException {
        FileInputStream stream = new FileInputStream(pFileName);
        FileChannel channel = stream.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
        channel.read(buffer);
        channel.close();
        DDD.dumpHex(buffer.array());
    }

    public static void dumpHex(byte[] pByteData) {
        DDD.dumpHex(pByteData, 0, 64);
    }

    public static void dumpHex(byte[] pByteData, int start, int size) {
        System.out.println("\u30d0\u30a4\u30c8\u30c0\u30f3\u30d7 START:" + start + " , LIMIT:" + size + "]   \u5168\u30d0\u30a4\u30c8\u6570=" + pByteData.length);
        String buff = "";
        int i = start;
        while (i < pByteData.length) {
            if (i % 16 > 0) {
                buff = String.valueOf(buff) + " ";
            }
            buff = String.valueOf(buff) + DDD.byte2HexStr(pByteData[i]);
            if ((i + 1) % 16 == 0) {
                System.out.println("[" + i + "]\t" + buff);
                buff = "";
            }
            if (i > size) {
                return;
            }
            ++i;
        }
        if (buff.length() > 0) {
            System.out.println("[" + i + "]\t" + buff);
        }
    }

    public static String byte2HexStr(byte pVal) {
        String hexStr = "";
        if (pVal >= 0 && pVal < 16) {
            hexStr = String.valueOf(hexStr) + "0";
        }
        return String.valueOf(hexStr) + Integer.toHexString(pVal & 0xFF);
    }

    public static String short2Bin(short pVal) {
        String binStr = "0000000000000000" + Integer.toBinaryString(pVal & 0xFFFF);
        if (binStr.length() > 16) {
            binStr = binStr.substring(binStr.length() - 16);
        }
        return binStr;
    }

    public static String byte2Bin(byte pVal) {
        String binStr = "00000000" + Integer.toBinaryString(pVal & 0xFF);
        if (binStr.length() > 8) {
            binStr = binStr.substring(binStr.length() - 8);
        }
        return binStr;
    }

    public static String getFreeMem() {
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        return "(FreeMem:" + free * 100L / total + "%)";
    }

    public static void startTime(String pMsg) {
        timeCheck = System.currentTimeMillis();
        System.out.println(String.valueOf(DDD.getFreeMem()) + pMsg);
    }

    public static void checkTime(String pMsg) {
        long now = System.currentTimeMillis();
        System.out.println(String.valueOf(DDD.getFreeMem()) + (float)(now - timeCheck) + "..." + pMsg);
        timeCheck = System.currentTimeMillis();
    }
}

