/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.views.swf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.plugin.SwfCaptureParams;
import jp.sourceforge.swf2bmp2avi.views.swf.SwfCapturePanel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class SwfCaptureDialog
extends Dialog {
    public static final int RETURN_CODE_COMPLETE = 100;
    public static final int RETURN_CODE_USER_STOP = 10;
    public static final int RETURN_CODE_FRAME_LOST = -99;
    private Label topLabel_;
    private Label infoLabel_;
    private SwfCapturePanel swfPanel_;
    private Button chkAutoStop_;
    private ProgressBar progressBar_;
    private Label lblStat_;
    private int beforeFrm_;
    private SwfCaptureParams swfCaptureParams_;

    public SwfCaptureDialog(Shell pParent, SwfCaptureParams pSwfCaptureParams) {
        super(pParent);
        this.setShellStyle(84064);
        this.setSwfCaptureParams(pSwfCaptureParams);
    }

    protected void finalize() throws Throwable {
        if (this.swfPanel_ != null) {
            this.swfPanel_.dispose();
        }
        super.finalize();
    }

    private void log(String pMsg) {
        Activator.msg("[" + ((Object)((Object)this)).getClass().getSimpleName() + "]" + pMsg);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.topLabel_ = new Label(composite, 0x1000000);
        this.topLabel_.setText("SWF:" + this.swfCaptureParams_.getSwfFileName());
        this.infoLabel_ = new Label(composite, 0x1000000);
        String info = "(FPS)" + this.swfCaptureParams_.getBaseFps();
        if (this.swfCaptureParams_.getBaseFps() == this.swfCaptureParams_.getSwfFps()) {
            info = String.valueOf(info) + " \u2192 " + this.swfCaptureParams_.getSwfFps();
        }
        info = String.valueOf(info) + "  (SIZE)" + this.swfCaptureParams_.getSwfWidth() + " x " + this.swfCaptureParams_.getSwfHeight();
        this.infoLabel_.setText(info);
        try {
            this.swfPanel_ = new SwfCapturePanel(composite, this.swfCaptureParams_);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.chkAutoStop_ = new Button(composite, 32);
        this.chkAutoStop_.setText("\u81ea\u52d5\u7d42\u4e86(\u6700\u7d42\u30d5\u30ec\u30fc\u30e0\u5230\u9054\u3001\u540c\u30d5\u30ec\u30fc\u30e0\u30eb\u30fc\u30d7\u3001\u524d\u306e\u30d5\u30ec\u30fc\u30e0\u3078\u306e\u79fb\u52d5\u3092\u691c\u51fa\u3059\u308b\u3068\u81ea\u52d5\u3067\u7d42\u4e86)");
        this.chkAutoStop_.setToolTipText("\u81ea\u52d5\u7d42\u4e86\u3092\u884c\u308f\u306a\u3044\u5834\u5408\u306f\u624b\u52d5\u3067\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        this.chkAutoStop_.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("swf2avi.swf.caprute_auto_stop"));
        this.progressBar_ = new ProgressBar(composite, 256);
        this.progressBar_.setBounds(10, 10, 160, 20);
        this.progressBar_.setEnabled(false);
        this.lblStat_ = new Label(composite, 0);
        this.lblStat_.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.lblStat_.setText("\u5b9f\u884c\u30dc\u30bf\u30f3\u3092\u62bc\u4e0b\u3059\u308b\u3068\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc\u3092\u958b\u59cb\u3057\u307e\u3059\n ");
        this.initLayout(composite);
        this.swfPanel_.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent pEvt) {
                SwfCaptureDialog.this.checkAsyncExec(new Runnable(){

                    public void run() {
                        SwfCaptureDialog.this.onSwfPropetyChanged(pEvt);
                    }
                });
                SwfCaptureDialog.this.log(pEvt.getPropertyName());
            }
        });
        return composite;
    }

    private void initLayout(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 3;
        gridLayout.marginWidth = 3;
        gridLayout.horizontalSpacing = 4;
        gridLayout.verticalSpacing = 4;
        parent.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.horizontalAlignment = 2;
        gridData.minimumWidth = this.swfCaptureParams_.getSwfWidth();
        gridData.minimumHeight = this.swfCaptureParams_.getSwfHeight();
        this.swfPanel_.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.chkAutoStop_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.progressBar_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.lblStat_.setLayoutData((Object)gridData);
    }

    private void onSwfPropetyChanged(PropertyChangeEvent pEvt) {
        if (pEvt.getPropertyName().equals("START_SAVE")) {
            this.progressBar_.setMinimum(this.swfCaptureParams_.getSwfStartFrame());
            this.progressBar_.setMaximum(this.swfCaptureParams_.getSwfEndFrame());
            this.progressBar_.setSelection(0);
            this.progressBar_.setEnabled(true);
        } else if (pEvt.getPropertyName().equals("FRAME_SAVE")) {
            int frame = 0;
            try {
                frame = (Integer)pEvt.getNewValue();
            }
            catch (Exception exception) {}
            this.progressBar_.setSelection(frame + 1);
            if (this.beforeFrm_ > frame) {
                String msg = "\u524d\u30d5\u30ec\u30fc\u30e0\u79fb\u52d5\u767a\u751f( " + this.beforeFrm_ + " \u2192 " + frame + " )";
                if (!this.chkAutoStop_.getSelection()) {
                    msg = String.valueOf(msg) + "\n \u81ea\u52d5\u7d42\u4e86\u304cOFF\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3001\u624b\u52d5\u3067\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                }
                this.lblStat_.setText(msg);
            } else if (this.beforeFrm_ == frame) {
                String msg = "\u540c\u30d5\u30ec\u30fc\u30e0\u30a4\u30d9\u30f3\u30c8\u767a\u751f( " + this.beforeFrm_ + " \u2192 " + frame + " )";
                if (!this.chkAutoStop_.getSelection()) {
                    msg = String.valueOf(msg) + "\n \u81ea\u52d5\u7d42\u4e86\u304cOFF\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3001\u624b\u52d5\u3067\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                }
                this.lblStat_.setText(msg);
            }
            this.beforeFrm_ = frame;
        } else if (pEvt.getPropertyName().equals("END_SAVE")) {
            if (this.swfPanel_.isLoatFrame()) {
                this.setReturnCode(-99);
            } else {
                this.setReturnCode(100);
            }
            this.close();
        }
    }

    private boolean checkAsyncExec(Runnable pRunnable) {
        Display display = this.getShell().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(pRunnable);
            return true;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10, "\u5b9f\u3000\u884c", true);
        this.createButton(parent, 12, "\u30ad\u30e3\u30f3\u30bb\u30eb", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 10) {
            this.log("\u5b9f\u884c\u30dc\u30bf\u30f3\u62bc\u4e0b");
            this.checkAsyncExec(new Runnable(){

                public void run() {
                    SwfCaptureDialog.this.startCapure();
                }
            });
            this.getButton(10).setEnabled(false);
            this.getButton(12).setText("\u7d42\u3000\u4e86");
        } else if (buttonId == 12) {
            this.log("\u7d42\u4e86\u30dc\u30bf\u30f3\u62bc\u4e0b");
            this.checkAsyncExec(new Runnable(){

                public void run() {
                    SwfCaptureDialog.this.swfPanel_.endCapture();
                }
            });
            this.setReturnCode(10);
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    private void startCapure() {
        this.chkAutoStop_.setEnabled(false);
        this.beforeFrm_ = 0;
        boolean isAutoStop = this.chkAutoStop_.getSelection();
        if (!isAutoStop) {
            this.lblStat_.setText("\u81ea\u52d5\u7d42\u4e86\u304cOFF\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3001\u624b\u52d5\u3067\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        } else {
            this.lblStat_.setText("\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc\u4e2d\u306f\u3001\u753b\u9762\u304c\u91cd\u306a\u3063\u305f\u308a\u30b9\u30af\u30ea\u30fc\u30f3\u30bb\u30fc\u30d0\u30fc\u304c\u8d77\u52d5\u3057\u306a\u3044\u3088\u3046\u306b\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
        this.swfPanel_.startCapture(isAutoStop);
    }

    public SwfCaptureParams getSwfCaptureParams() {
        return this.swfCaptureParams_;
    }

    public void setSwfCaptureParams(SwfCaptureParams pSwfCaptureParams) {
        this.swfCaptureParams_ = pSwfCaptureParams;
    }
}

