/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.protocol.rmi.DeployRMISocketFactory;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.DirectProxyHandler;
import com.sun.deploy.net.proxy.ManualProxyHandler;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.net.proxy.UserDefinedProxyConfig;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.net.URL;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;

public class DynamicProxyManager {
    private static HashMap proxyCache = new HashMap();
    private static ProxyHandler handler = null;

    public static synchronized ProxyInfo getProxyInfo(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(uRL.getPort());
        String string = stringBuffer.toString();
        ProxyInfo proxyInfo = null;
        if (handler.isProxyCacheSupported()) {
            proxyInfo = (ProxyInfo)proxyCache.get(string);
        }
        if (proxyInfo == null) {
            try {
                if (!uRL.getHost().equals("127.0.0.1") && !uRL.getHost().equals("localhost")) {
                    ProxyInfo[] proxyInfoArray = handler.getProxyInfo(uRL);
                    proxyInfo = proxyInfoArray[0];
                }
                if (proxyInfo == null) {
                    proxyInfo = new ProxyInfo(null);
                }
                proxyCache.put(string.toString(), proxyInfo);
            }
            catch (ProxyUnavailableException proxyUnavailableException) {
                Trace.msgNetPrintln("net.proxy.service.not_available", new Object[]{uRL});
                proxyInfo = new ProxyInfo(null);
            }
        }
        return proxyInfo;
    }

    public static synchronized void setNoProxy(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(uRL.getPort());
        String string = stringBuffer.toString();
        if (handler.isProxyCacheSupported()) {
            proxyCache.put(string.toString(), new ProxyInfo(null));
        }
    }

    public static synchronized void reset() {
        try {
            Object object;
            proxyCache.clear();
            UserDefinedProxyConfig userDefinedProxyConfig = new UserDefinedProxyConfig();
            BrowserProxyInfo browserProxyInfo = userDefinedProxyConfig.getBrowserProxyInfo();
            Service service = ServiceManager.getService();
            if (browserProxyInfo.getType() == 3) {
                object = service.getProxyConfig();
                browserProxyInfo = object.getBrowserProxyInfo();
            }
            switch (browserProxyInfo.getType()) {
                case 4: {
                    try {
                        object = service.getSystemProxyHandler();
                        if (object == null) {
                            throw new ProxyConfigException("Unable to obtain browser proxy handler.");
                        }
                        handler = object;
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.ignoredException(proxyConfigException);
                    }
                    break;
                }
                case 3: {
                    try {
                        object = service.getBrowserProxyHandler();
                        if (object == null) {
                            throw new ProxyConfigException("Unable to obtain browser proxy handler.");
                        }
                        handler = object;
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.ignoredException(proxyConfigException);
                    }
                    break;
                }
                case 0: {
                    try {
                        handler = new DirectProxyHandler();
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.ignoredException(proxyConfigException);
                    }
                    break;
                }
                case 1: {
                    try {
                        handler = new ManualProxyHandler();
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.msgNetPrintln("net.proxy.loading.manual.error");
                        try {
                            browserProxyInfo.setType(0);
                            handler = new DirectProxyHandler();
                            handler.init(browserProxyInfo);
                        }
                        catch (ProxyConfigException proxyConfigException2) {
                            Trace.ignoredException(proxyConfigException2);
                        }
                    }
                    break;
                }
                case 2: {
                    try {
                        object = service.getAutoProxyHandler();
                        if (object == null) {
                            throw new ProxyConfigException("Unable to obtain auto proxy handler.");
                        }
                        handler = object;
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.msgNetPrintln("net.proxy.loading.auto.error");
                        try {
                            browserProxyInfo.setType(1);
                            handler = new ManualProxyHandler();
                            handler.init(browserProxyInfo);
                        }
                        catch (ProxyConfigException proxyConfigException3) {
                            Trace.msgNetPrintln("net.proxy.loading.manual.error");
                            try {
                                browserProxyInfo.setType(0);
                                handler = new DirectProxyHandler();
                                handler.init(browserProxyInfo);
                            }
                            catch (ProxyConfigException proxyConfigException4) {
                                Trace.ignoredException(proxyConfigException4);
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("DynamicProxyManager: Invalid Proxy Type");
                }
            }
            try {
                boolean bl;
                object = System.getProperty("jnlp.cfg.normifactory");
                boolean bl2 = bl = !"true".equals(object);
                if (browserProxyInfo.getType() != 0 && bl) {
                    RMISocketFactory.setSocketFactory((RMISocketFactory)((Object)new DeployRMISocketFactory()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = browserProxyInfo;
            AccessController.doPrivileged(new PrivilegedAction((BrowserProxyInfo)object){
                private final /* synthetic */ BrowserProxyInfo val$info;
                {
                    this.val$info = browserProxyInfo;
                }

                public Object run() {
                    DynamicProxyManager.setProperties(this.val$info);
                    return null;
                }
            });
            Trace.msgNetPrintln(browserProxyInfo.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            DialogFactory.showExceptionDialog(throwable);
        }
    }

    private static void setProperties(BrowserProxyInfo browserProxyInfo) {
        Properties properties = System.getProperties();
        int n = browserProxyInfo.getType();
        StringBuffer stringBuffer = new StringBuffer();
        if (browserProxyInfo.getHttpHost() != null) {
            stringBuffer.append("http=" + browserProxyInfo.getHttpHost());
            if (browserProxyInfo.getHttpPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getHttpPort());
            }
        }
        if (browserProxyInfo.getHttpsHost() != null) {
            stringBuffer.append(",https=" + browserProxyInfo.getHttpsHost());
            if (browserProxyInfo.getHttpsPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getHttpsPort());
            }
        }
        if (browserProxyInfo.getFtpHost() != null) {
            stringBuffer.append(",ftp=" + browserProxyInfo.getFtpHost());
            if (browserProxyInfo.getFtpPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getFtpPort());
            }
        }
        if (browserProxyInfo.getGopherHost() != null) {
            stringBuffer.append(",gopher=" + browserProxyInfo.getGopherHost());
            if (browserProxyInfo.getGopherPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getGopherPort());
            }
        }
        if (browserProxyInfo.getSocksHost() != null) {
            stringBuffer.append(",socks=" + browserProxyInfo.getSocksHost());
            if (browserProxyInfo.getSocksPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getSocksPort());
            }
        }
        String string = stringBuffer.toString();
        String[] stringArray = browserProxyInfo.getOverrides();
        String string2 = null;
        if (stringArray != null) {
            stringBuffer = new StringBuffer();
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[i]);
            }
            string2 = stringBuffer.toString();
        }
        properties.remove("javaplugin.proxy.config.type");
        properties.remove("javaplugin.proxy.config.list");
        properties.remove("javaplugin.proxy.config.bypass");
        if (n == 0) {
            properties.put("javaplugin.proxy.config.type", "direct");
        } else if (n == 1) {
            properties.put("javaplugin.proxy.config.type", "manual");
            if (string != null) {
                properties.put("javaplugin.proxy.config.list", string);
            }
            if (string2 != null) {
                properties.put("javaplugin.proxy.config.bypass", string2);
            }
        } else if (n == 2) {
            properties.put("javaplugin.proxy.config.type", "auto");
        } else if (n == 3) {
            properties.put("javaplugin.proxy.config.type", "browser");
            if (string != null) {
                properties.put("javaplugin.proxy.config.list", string);
            }
            if (string2 != null) {
                properties.put("javaplugin.proxy.config.bypass", string2);
            }
        } else {
            properties.put("javaplugin.proxy.config.type", "unknown");
        }
        System.setProperties(properties);
    }
}

