/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TrustDecider {
    private static RootCertStore rootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserRootStore = null;
    private static CertStore browserTrustedStore = null;
    private static Map trustedPrincipals;
    private static boolean isBrowserRootStoreLoaded;
    private static Object _lock;

    public static synchronized void reset() {
        rootStore = RootCertStore.getInstance();
        permanentStore = new DeploySigningCertStore();
        sessionStore = new SessionCertStore();
        deniedStore = new DeniedCertStore();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            browserRootStore = service.getBrowserSigningRootCertStore();
            browserTrustedStore = service.getBrowserTrustedCertStore();
            isBrowserRootStoreLoaded = false;
        }
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        return TrustDecider.isAllPermissionGranted(codeSource, new AppInfo(), false);
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        return TrustDecider.isAllPermissionGranted(codeSource, appInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo, boolean bl) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        int n;
        Certificate[] certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        LinkedList<Boolean> linkedList = new LinkedList<Boolean>();
        String string = null;
        rootStore.load();
        permanentStore.load();
        sessionStore.load();
        deniedStore.load();
        if (browserRootStore != null && !isBrowserRootStoreLoaded) {
            browserRootStore.load();
            isBrowserRootStoreLoaded = true;
        }
        if (browserTrustedStore != null) {
            browserTrustedStore.load();
        }
        while (n3 < certificateArray.length) {
            n = n2;
            while (n + 1 < certificateArray.length && certificateArray[n] instanceof X509Certificate && certificateArray[n + 1] instanceof X509Certificate && CertUtils.isIssuerOf((X509Certificate)certificateArray[n], (X509Certificate)certificateArray[n + 1])) {
                ++n;
            }
            n3 = n + 1;
            if (deniedStore.contains(certificateArray[n2])) {
                linkedList.add(n4, new Boolean(true));
            } else {
                linkedList.add(n4, new Boolean(false));
                if (permanentStore.contains(certificateArray[n2])) {
                    return true;
                }
                if (sessionStore.contains(certificateArray[n2])) {
                    return true;
                }
                if (browserTrustedStore != null && browserTrustedStore.contains(certificateArray[n2])) {
                    return true;
                }
            }
            n2 = n3;
            ++n4;
        }
        n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        n2 = 0;
        n3 = 0;
        TrustDecider.getCertMap(rootStore.getKeyStore(0), rootStore.getKeyStore(1));
        Date date = new Date();
        certificateArray = TrustDecider.canonicalize(certificateArray, date);
        n4 = 0;
        while (n3 < certificateArray.length) {
            Serializable serializable;
            int n5 = n2;
            CertificateExpiredException certificateExpiredException = null;
            CertificateNotYetValidException certificateNotYetValidException = null;
            for (n5 = n2; n5 < certificateArray.length; ++n5) {
                Serializable serializable2;
                block43: {
                    serializable = null;
                    serializable2 = null;
                    if (certificateArray[n5] instanceof X509Certificate) {
                        serializable = (X509Certificate)certificateArray[n5];
                    }
                    serializable2 = n5 + 1 < certificateArray.length && certificateArray[n5 + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n5 + 1] : serializable;
                    try {
                        ((X509Certificate)serializable).checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException2) {
                        if (certificateExpiredException == null) {
                            certificateExpiredException = certificateExpiredException2;
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                        if (certificateNotYetValidException != null) break block43;
                        certificateNotYetValidException = certificateNotYetValidException2;
                    }
                }
                if (!(rootStore.contains((Certificate)serializable) || n5 + 1 == certificateArray.length || !CertUtils.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2) || browserRootStore != null && browserRootStore.contains((Certificate)serializable))) {
                    CertUtils.checkUsageForCodeSigning((X509Certificate)serializable, n5 - n2);
                }
                if (!CertUtils.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                try {
                    ((Certificate)serializable).verify(((Certificate)serializable2).getPublicKey());
                    continue;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    Trace.msgSecurityPrintln("trustdecider.check.signature");
                    string = ResourceManager.getMessage("trustdecider.check.signature");
                    throw new CertificateException(string);
                }
            }
            n3 = n5 < certificateArray.length ? n5 + 1 : n5;
            serializable = (Boolean)linkedList.get(n4);
            if (!((Boolean)serializable).booleanValue()) {
                int n6;
                Object object;
                boolean bl4;
                if (!Config.getBooleanProperty("deployment.security.askgrantdialog.show")) {
                    string = ResourceManager.getMessage("trustdecider.user.cannot.grant.any");
                    throw new CertificateException(string);
                }
                boolean bl5 = bl4 = rootStore.verify(certificateArray[n3 - 1]) || browserRootStore != null && browserRootStore.verify(certificateArray[n3 - 1]);
                if (!bl4) {
                    if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                        string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                        throw new CertificateException(string);
                    }
                    n = 1;
                }
                if (certificateExpiredException != null || certificateNotYetValidException != null) {
                    bl2 = true;
                }
                Date date2 = null;
                try {
                    CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
                    object = codeSignerArray[n4].getTimestamp();
                    if (object != null) {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                        date2 = ((Timestamp)object).getTimestamp();
                        CertPath certPath = ((Timestamp)object).getSignerCertPath();
                        if (bl2) {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
                            Date date3 = ((X509Certificate)certificateArray[n3 - 1]).getNotAfter();
                            Date date4 = ((X509Certificate)certificateArray[n3 - 1]).getNotBefore();
                            if (date2.before(date3) && date2.after(date4)) {
                                Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                                boolean bl6 = TrustDecider.checkTSAPath(certPath, date);
                                if (bl6) {
                                    bl2 = false;
                                } else {
                                    date2 = null;
                                }
                            } else {
                                Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.noneed");
                        }
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
                }
                object = _lock;
                synchronized (object) {
                    n6 = TrustDeciderDialog.showDialog(certificateArray, codeSource.getLocation(), n2, n3, n != 0, bl2, date2, appInfo, false, bl);
                }
                if (n6 == 0) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                    sessionStore.add(certificateArray[n2]);
                    sessionStore.save();
                    bl3 = true;
                } else if (n6 == 2) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                    permanentStore.add(certificateArray[n2]);
                    permanentStore.save();
                    bl3 = true;
                } else {
                    Trace.msgSecurityPrintln("trustdecider.user.deny");
                    deniedStore.add(certificateArray[n2]);
                    deniedStore.save();
                }
                if (bl3) {
                    return true;
                }
            }
            n2 = n3;
            ++n4;
        }
        return false;
    }

    private static boolean checkTSAPath(CertPath certPath, Date date) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        try {
            int n;
            List<? extends Certificate> list = certPath.getCertificates();
            Object[] objectArray = list.toArray();
            int n2 = objectArray.length;
            Certificate[] certificateArray = new Certificate[n2];
            for (n = 0; n < n2; ++n) {
                certificateArray[n] = (Certificate)objectArray[n];
            }
            Certificate certificate = (certificateArray = TrustDecider.canonicalize(certificateArray, date))[(n = certificateArray.length) - 1];
            if (rootStore.verify(certificate) || browserRootStore != null && browserRootStore.verify(certificate)) {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.inca");
                for (int i = 0; i < n - 1; ++i) {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
                    X509Certificate x509Certificate2 = (X509Certificate)certificateArray[i + 1];
                    try {
                        CertUtils.checkUsageForCodeSigning(x509Certificate, i, true);
                        x509Certificate.verify(x509Certificate2.getPublicKey());
                        continue;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        Trace.msgSecurityPrintln("trustdecider.check.signature");
                        return false;
                    }
                }
                return true;
            }
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notinca");
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static synchronized void getCertMap(KeyStore keyStore, KeyStore keyStore2) throws KeyStoreException {
        Certificate certificate;
        String string;
        Enumeration<String> enumeration;
        trustedPrincipals = new HashMap();
        if (keyStore != null) {
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
                TrustDecider.addTrustedCert((X509Certificate)certificate);
            }
        }
        if (keyStore2 != null) {
            enumeration = keyStore2.aliases();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (!keyStore2.isCertificateEntry(string) || !((certificate = keyStore2.getCertificate(string)) instanceof X509Certificate)) continue;
                TrustDecider.addTrustedCert((X509Certificate)certificate);
            }
        }
    }

    private static synchronized void addTrustedCert(X509Certificate x509Certificate) {
        Principal principal = X509Util.getSubjectPrincipal(x509Certificate);
        ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)trustedPrincipals.get(principal);
        if (arrayList == null) {
            arrayList = new ArrayList<X509Certificate>();
            trustedPrincipals.put(principal, arrayList);
        }
        arrayList.add(x509Certificate);
    }

    private static Certificate[] canonicalize(Certificate[] certificateArray, Date date) throws CertificateException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(certificateArray.length);
        boolean bl = false;
        if (certificateArray.length == 0) {
            return certificateArray;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = (X509Certificate)certificateArray[i];
            X509Certificate x509Certificate3 = TrustDecider.getTrustedCertificate(x509Certificate2, date);
            if (x509Certificate3 != null) {
                Trace.msgSecurityPrintln("trustdecider.check.canonicalize.updatecert");
                x509Certificate2 = x509Certificate3;
                bl = true;
            }
            arrayList.add(x509Certificate2);
            Principal principal = X509Util.getSubjectPrincipal(certificateArray[i]);
            Principal principal2 = X509Util.getIssuerPrincipal(certificateArray[i]);
            Principal principal3 = null;
            if (i < certificateArray.length - 1) {
                principal3 = X509Util.getSubjectPrincipal(certificateArray[i + 1]);
            }
            if (((Object)principal2).equals(principal) || ((Object)principal2).equals(principal3) || (x509Certificate = TrustDecider.getTrustedIssuerCertificate((X509Certificate)certificateArray[i], date)) == null) continue;
            Trace.msgSecurityPrintln("trustdecider.check.canonicalize.missing");
            bl = true;
            arrayList.add(x509Certificate);
        }
        if (bl) {
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        return certificateArray;
    }

    private static synchronized X509Certificate getTrustedCertificate(X509Certificate x509Certificate, Date date) {
        Principal principal = X509Util.getSubjectPrincipal(x509Certificate);
        List list = (List)trustedPrincipals.get(principal);
        if (list == null) {
            return null;
        }
        Principal principal2 = X509Util.getIssuerPrincipal(x509Certificate);
        PublicKey publicKey = x509Certificate.getPublicKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate) || !((Object)X509Util.getIssuerPrincipal(x509Certificate2)).equals(principal2) || !x509Certificate2.getPublicKey().equals(publicKey)) continue;
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            Trace.msgSecurityPrintln("trustdecider.check.gettrustedcert.find");
            return x509Certificate2;
        }
        return null;
    }

    private static synchronized X509Certificate getTrustedIssuerCertificate(X509Certificate x509Certificate, Date date) {
        Principal principal = X509Util.getIssuerPrincipal(x509Certificate);
        List list = (List)trustedPrincipals.get(principal);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            Trace.msgSecurityPrintln("trustdecider.check.gettrustedissuercert.find");
            return x509Certificate2;
        }
        return null;
    }

    public static synchronized boolean isSigner(Certificate certificate, Certificate certificate2) {
        try {
            certificate.verify(certificate2.getPublicKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        isBrowserRootStoreLoaded = false;
        _lock = new Object();
        TrustDecider.reset();
    }
}

