/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertType;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.ClientCertDialog;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509KeyManager;
import javax.swing.JButton;
import javax.swing.JPasswordField;
import javax.swing.LookAndFeel;

public final class X509DeployKeyManager
implements X509KeyManager {
    private X509KeyManager myKeyManager = null;
    private X509KeyManager browserKeyManager = null;
    private String mykeyStore = null;
    private KeyStore browserKeyStore = null;
    private boolean isWindows = Config.getOSName().indexOf("Windows") != -1;
    private static ThreadLocal clientCertDialogCancelled = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static ThreadLocal passwdDialogCancelled = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };

    public X509DeployKeyManager() {
        this.mykeyStore = Config.getUserClientAuthCertFile();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            this.browserKeyStore = service.getBrowserClientAuthKeyStore();
        }
    }

    private void init() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
                    X509DeployKeyManager.this.do_init();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            if (exception instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)exception;
            }
            if (exception instanceof FileNotFoundException) {
                throw (FileNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
    }

    private void do_init() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        Object object;
        if (this.browserKeyStore != null) {
            this.browserKeyStore.load(null, new char[0]);
            object = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            ((KeyManagerFactory)object).init(this.browserKeyStore, new char[0]);
            KeyManager[] keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            for (int i = 0; i < keyManagerArray.length; ++i) {
                if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                this.browserKeyManager = (X509KeyManager)keyManagerArray[i];
                break;
            }
        }
        if (((File)(object = new File(this.mykeyStore))).exists()) {
            boolean bl = true;
            while (bl) {
                Object object2;
                String string;
                try {
                    char[] cArray = this.getPasswordDialog("clientauth.password.dialog.text");
                    if (passwdDialogCancelled.get() == Boolean.TRUE) break;
                    string = System.getProperty("javax.net.ssl.keyStoreType");
                    if (string == null) {
                        string = "JKS";
                    }
                    object2 = KeyStore.getInstance(string);
                    ((KeyStore)object2).load(new BufferedInputStream(new FileInputStream(this.mykeyStore)), cArray);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
                    keyManagerFactory.init((KeyStore)object2, cArray);
                    KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                    for (int i = 0; i < keyManagerArray.length; ++i) {
                        if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                        this.myKeyManager = (X509KeyManager)keyManagerArray[i];
                        break;
                    }
                    bl = false;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (Trace.isAutomationEnabled()) continue;
                    string = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.text");
                    object2 = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.caption");
                    DialogFactory.showExceptionDialog(null, iOException, string, (String)object2);
                }
            }
        }
    }

    public synchronized String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        HashMap<String, X509Certificate[]> hashMap = new HashMap<String, X509Certificate[]>();
        String[] stringArray2 = new HashMap();
        String string = null;
        if (clientCertDialogCancelled.get() == Boolean.FALSE) {
            String[] stringArray3;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray3 = this.getClientAliases(stringArray[i], principalArray);
                if (stringArray3 == null || stringArray3.length <= 0) continue;
                for (int j = 0; j < stringArray3.length; ++j) {
                    int n = CertType.PLUGIN.getType().length();
                    String string2 = stringArray3[j].substring(n);
                    X509Certificate[] x509CertificateArray = this.getCertificateChain(string2);
                    try {
                        if (!CertUtils.checkTLSClient(x509CertificateArray[0])) continue;
                        hashMap.put(string2, x509CertificateArray);
                        if (stringArray3[j].startsWith(CertType.PLUGIN.getType())) {
                            stringArray2.put(string2, CertType.PLUGIN);
                        }
                        if (!stringArray3[j].startsWith(CertType.BROWSER.getType())) continue;
                        stringArray2.put(string2, CertType.BROWSER);
                        continue;
                    }
                    catch (CertificateException certificateException) {
                        Trace.msgSecurityPrintln("clientauth.checkTLSClient.failed", new Object[]{string2});
                    }
                }
            }
            final HashMap<String, X509Certificate[]> hashMap2 = hashMap;
            stringArray3 = stringArray2;
            if (Config.getBooleanProperty("deployment.security.clientauth.keystore.auto") && hashMap2.size() == 1) {
                Object[] objectArray = hashMap2.keySet().toArray();
                string = (String)objectArray[0];
            } else {
                string = (String)AccessController.doPrivileged(new PrivilegedAction((HashMap)stringArray3){
                    private final /* synthetic */ HashMap val$theClientAuthTypeMap;
                    {
                        this.val$theClientAuthTypeMap = hashMap22;
                    }

                    public Object run() {
                        try {
                            return DeploySysRun.execute(new DeploySysAction(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Object execute() throws Exception {
                                    LookAndFeel lookAndFeel = null;
                                    try {
                                        lookAndFeel = DeployUIManager.setLookAndFeel();
                                        ClientCertDialog clientCertDialog = new ClientCertDialog(hashMap2, val$theClientAuthTypeMap);
                                        String string = clientCertDialog.DoModal();
                                        return string;
                                    }
                                    finally {
                                        DeployUIManager.restoreLookAndFeel(lookAndFeel);
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {
                            Trace.ignoredException(exception);
                            return null;
                        }
                    }
                });
            }
            if (string == null) {
                clientCertDialogCancelled.set(Boolean.TRUE);
            }
            return string;
        }
        return null;
    }

    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseClientAlias(stringArray, principalArray, null);
    }

    public synchronized String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get() == Boolean.FALSE) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = null;
        if (this.myKeyManager != null) {
            string2 = this.myKeyManager.chooseServerAlias(string, principalArray, socket);
        }
        if (string2 == null && this.browserKeyManager != null) {
            string2 = this.browserKeyManager.chooseServerAlias(string, principalArray, socket);
        }
        return string2;
    }

    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseServerAlias(string, principalArray, null);
    }

    public synchronized X509Certificate[] getCertificateChain(String string) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get() == Boolean.FALSE) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        X509Certificate[] x509CertificateArray = null;
        if (this.myKeyManager != null) {
            x509CertificateArray = this.myKeyManager.getCertificateChain(string);
        }
        if (x509CertificateArray == null && this.browserKeyManager != null) {
            x509CertificateArray = this.browserKeyManager.getCertificateChain(string);
        }
        return x509CertificateArray;
    }

    public synchronized String[] getClientAliases(String string, Principal[] principalArray) {
        int n;
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get() == Boolean.FALSE) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.myKeyManager != null) {
            stringArray = this.myKeyManager.getClientAliases(string, principalArray);
        }
        if (this.browserKeyManager != null) {
            stringArray2 = this.browserKeyManager.getClientAliases(string, principalArray);
        }
        if (stringArray == null) {
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = CertType.BROWSER.getType() + stringArray2[i];
                }
            }
            return stringArray2;
        }
        if (stringArray2 == null) {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = CertType.PLUGIN.getType() + stringArray[i];
                }
            }
            return stringArray;
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = CertType.PLUGIN.getType() + stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = CertType.BROWSER.getType() + stringArray2[n];
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public synchronized String[] getServerAliases(String string, Principal[] principalArray) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get() == Boolean.FALSE) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.myKeyManager != null) {
            stringArray = this.myKeyManager.getServerAliases(string, principalArray);
        }
        if (this.browserKeyManager != null) {
            stringArray2 = this.browserKeyManager.getServerAliases(string, principalArray);
        }
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public PrivateKey getPrivateKey(String string) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get() == Boolean.FALSE) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PrivateKey privateKey = null;
        if (this.myKeyManager != null) {
            privateKey = this.myKeyManager.getPrivateKey(string);
        }
        if (privateKey == null && this.browserKeyManager != null) {
            privateKey = this.browserKeyManager.getPrivateKey(string);
        }
        return privateKey;
    }

    private char[] getPasswordDialog(final String string) {
        try {
            char[] cArray = (char[])DeploySysRun.execute(new DeploySysAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object execute() throws Exception {
                    LookAndFeel lookAndFeel = null;
                    try {
                        lookAndFeel = DeployUIManager.setLookAndFeel();
                        char[] cArray = X509DeployKeyManager.this.getPasswordDialogImp(string);
                        return cArray;
                    }
                    finally {
                        DeployUIManager.restoreLookAndFeel(lookAndFeel);
                    }
                }
            });
            if (cArray == null) {
                passwdDialogCancelled.set(Boolean.TRUE);
            }
            return cArray;
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return null;
        }
    }

    private char[] getPasswordDialogImp(String string) {
        String string2 = X509DeployKeyManager.getMessage(string);
        JPasswordField jPasswordField = new JPasswordField();
        Object[] objectArray = new Object[]{string2.toString(), jPasswordField};
        JButton jButton = new JButton(X509DeployKeyManager.getMessage("clientauth.password.dialog.buttonOK"));
        JButton jButton2 = new JButton(X509DeployKeyManager.getMessage("clientauth.password.dialog.buttonCancel"));
        String string3 = X509DeployKeyManager.getMessage("clientauth.password.dialog.caption");
        Object[] objectArray2 = new Object[]{jButton, jButton2};
        int n = DialogFactory.showOptionDialog(4, (Object)objectArray, string3, objectArray2, objectArray2[0]);
        char[] cArray = jPasswordField.getPassword();
        if (n == 0) {
            return cArray;
        }
        return null;
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }
}

