/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.ClientListenerInfo;
import com.sun.jmx.remote.internal.ListenerInfo;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.io.NotSerializableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.security.auth.Subject;

public abstract class ClientNotifForwarder {
    private final AccessControlContext acc;
    private static int threadId;
    private final ClassLoader defaultClassLoader;
    private final Executor executor;
    private final HashMap infoList = new HashMap();
    private long clientSequenceNumber = -1L;
    private final int maxNotifications;
    private final long timeout;
    private Integer mbeanRemovedNotifID = null;
    private Thread currentFetchThread;
    private boolean inited = false;
    private static final int STARTING = 0;
    private static final int STARTED = 1;
    private static final int STOPPING = 2;
    private static final int STOPPED = 3;
    private static final int TERMINATED = 4;
    private int state = 3;
    private boolean beingReconnected = false;
    private static final ClassLogger logger;

    public ClientNotifForwarder(Map map) {
        this(null, map);
    }

    public ClientNotifForwarder(ClassLoader classLoader, Map map) {
        this.maxNotifications = EnvHelp.getMaxFetchNotifNumber(map);
        this.timeout = EnvHelp.getFetchTimeout(map);
        Executor executor = (Executor)map.get("jmx.remote.x.fetch.notifications.executor");
        if (executor == null) {
            executor = new LinearExecutor();
        } else if (logger.traceOn()) {
            logger.trace("ClientNotifForwarder", "executor is " + executor);
        }
        this.defaultClassLoader = classLoader;
        this.executor = executor;
        this.acc = AccessController.getContext();
    }

    protected abstract NotificationResult fetchNotifs(long var1, int var3, long var4) throws IOException, ClassNotFoundException;

    protected abstract Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException;

    protected abstract void removeListenerForMBeanRemovedNotif(Integer var1) throws IOException, InstanceNotFoundException, ListenerNotFoundException;

    protected abstract void lostNotifs(String var1, long var2);

    public synchronized void addNotificationListener(Integer n, ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Subject subject) throws IOException, InstanceNotFoundException {
        if (logger.traceOn()) {
            logger.trace("addNotificationListener", "Add the listener " + notificationListener + " at " + objectName);
        }
        this.infoList.put(n, new ClientListenerInfo(n, objectName, notificationListener, notificationFilter, object, subject));
        this.init(false);
    }

    public synchronized Integer[] removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException, IOException {
        this.beforeRemove();
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + notificationListener + " from " + objectName);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = new ArrayList(this.infoList.values());
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList2.get(i);
            if (!clientListenerInfo.sameAs(objectName, notificationListener)) continue;
            arrayList.add(clientListenerInfo.getListenerID());
            this.infoList.remove(clientListenerInfo.getListenerID());
        }
        if (arrayList.isEmpty()) {
            throw new ListenerNotFoundException("Listener not found");
        }
        return arrayList.toArray(new Integer[0]);
    }

    public synchronized Integer removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + notificationListener + " from " + objectName);
        }
        this.beforeRemove();
        Integer n = null;
        ArrayList arrayList = new ArrayList(this.infoList.values());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList.get(i);
            if (!clientListenerInfo.sameAs(objectName, notificationListener, notificationFilter, object)) continue;
            n = clientListenerInfo.getListenerID();
            this.infoList.remove(n);
            break;
        }
        if (n == null) {
            throw new ListenerNotFoundException("Listener not found");
        }
        return n;
    }

    public synchronized Integer[] removeNotificationListener(ObjectName objectName) {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove all listeners registered at " + objectName);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = new ArrayList(this.infoList.values());
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList2.get(i);
            if (!clientListenerInfo.sameAs(objectName)) continue;
            arrayList.add(clientListenerInfo.getListenerID());
            this.infoList.remove(clientListenerInfo.getListenerID());
        }
        return arrayList.toArray(new Integer[0]);
    }

    public synchronized ListenerInfo[] getListenerInfo() {
        return this.infoList.values().toArray(new ListenerInfo[0]);
    }

    public synchronized ClientListenerInfo[] preReconnection() throws IOException {
        if (this.state == 4 || this.beingReconnected) {
            throw new IOException("Illegal state.");
        }
        ClientListenerInfo[] clientListenerInfoArray = this.infoList.values().toArray(new ClientListenerInfo[0]);
        this.beingReconnected = true;
        this.infoList.clear();
        return clientListenerInfoArray;
    }

    public synchronized void postReconnection(ClientListenerInfo[] clientListenerInfoArray) throws IOException {
        if (this.state == 4) {
            return;
        }
        boolean bl = logger.traceOn();
        int n = clientListenerInfoArray.length;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                logger.trace("addNotificationListeners", "Add a listener at " + clientListenerInfoArray[i].getListenerID());
            }
            this.infoList.put(clientListenerInfoArray[i].getListenerID(), clientListenerInfoArray[i]);
        }
        this.beingReconnected = false;
        this.notifyAll();
        if (this.currentFetchThread == Thread.currentThread() || this.state == 0 || this.state == 1) {
            try {
                this.mbeanRemovedNotifID = this.addListenerForMBeanRemovedNotif();
            }
            catch (Exception exception) {
                if (logger.traceOn()) {
                    logger.trace("init", "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered", exception);
                }
            }
        } else {
            while (this.state == 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    IOException iOException = new IOException(interruptedException.toString());
                    EnvHelp.initCause(iOException, interruptedException);
                    throw iOException;
                }
            }
            if (clientListenerInfoArray.length > 0) {
                this.init(true);
            } else if (this.infoList.size() > 0) {
                this.init(false);
            }
        }
    }

    public synchronized void terminate() {
        if (this.state == 4) {
            return;
        }
        if (logger.traceOn()) {
            logger.trace("terminate", "Terminating...");
        }
        if (this.state == 1) {
            this.infoList.clear();
        }
        this.setState(4);
    }

    private synchronized void setState(int n) {
        if (this.state == 4) {
            return;
        }
        this.state = n;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void init(boolean var1_1) throws IOException {
        switch (this.state) {
            case 1: {
                return;
            }
            case 0: {
                return;
            }
            case 4: {
                throw new IOException("The ClientNotifForwarder has been terminated.");
            }
            case 2: {
                if (this.beingReconnected) {
                    return;
                }
                while (this.state == 2) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var2_2) {
                        var3_6 = new IOException(var2_2.toString());
                        EnvHelp.initCause(var3_6, var2_2);
                        throw var3_6;
                    }
                }
                this.init(var1_1);
                return;
            }
            case 3: {
                if (this.beingReconnected) {
                    return;
                }
                if (ClientNotifForwarder.logger.traceOn()) {
                    ClientNotifForwarder.logger.trace("init", "Initializing...");
                }
                if (!var1_1) {
                    try {
                        var2_3 = this.fetchNotifs(-1L, 0, 0L);
                        this.clientSequenceNumber = var2_3.getNextSequenceNumber();
                    }
                    catch (ClassNotFoundException var2_4) {
                        ClientNotifForwarder.logger.warning("init", "Impossible exception: " + var2_4);
                        ClientNotifForwarder.logger.debug("init", var2_4);
                    }
                }
                try {
                    this.mbeanRemovedNotifID = this.addListenerForMBeanRemovedNotif();
                }
                catch (Exception var2_5) {
                    if (!ClientNotifForwarder.logger.traceOn()) ** GOTO lbl41
                    ClientNotifForwarder.logger.trace("init", "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered", var2_5);
                }
lbl41:
                // 3 sources

                this.setState(0);
                this.executor.execute(new NotifFetcher());
                return;
            }
        }
        throw new IOException("Unknown state.");
    }

    private synchronized void beforeRemove() throws IOException {
        while (this.beingReconnected) {
            if (this.state == 4) {
                throw new IOException("Terminated.");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                IOException iOException = new IOException(interruptedException.toString());
                EnvHelp.initCause(iOException, interruptedException);
                throw iOException;
            }
        }
        if (this.state == 4) {
            throw new IOException("Terminated.");
        }
    }

    static {
        logger = new ClassLogger("javax.management.remote.misc", "ClientNotifForwarder");
    }

    private static class LinearExecutor
    implements Executor {
        private Runnable command;
        private Thread thread;

        private LinearExecutor() {
        }

        public synchronized void execute(Runnable runnable) {
            if (this.command != null) {
                throw new IllegalArgumentException("More than one command");
            }
            this.command = runnable;
            if (this.thread == null) {
                this.thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            Runnable runnable;
                            LinearExecutor linearExecutor = LinearExecutor.this;
                            synchronized (linearExecutor) {
                                if (LinearExecutor.this.command == null) {
                                    LinearExecutor.this.thread = null;
                                    return;
                                }
                                runnable = LinearExecutor.this.command;
                                LinearExecutor.this.command = null;
                            }
                            runnable.run();
                        }
                    }
                };
                this.thread.setDaemon(true);
                this.thread.setName("ClientNotifForwarder-" + ++threadId);
                this.thread.start();
            }
        }
    }

    private class NotifFetcher
    implements Runnable {
        private volatile boolean alreadyLogged = false;

        private NotifFetcher() {
        }

        private void logOnce(String string, SecurityException securityException) {
            if (this.alreadyLogged) {
                return;
            }
            logger.config("setContextClassLoader", string);
            if (securityException != null) {
                logger.fine("setContextClassLoader", securityException);
            }
            this.alreadyLogged = true;
        }

        private final ClassLoader setContextClassLoader(final ClassLoader classLoader) {
            AccessControlContext accessControlContext = ClientNotifForwarder.this.acc;
            if (accessControlContext == null) {
                this.logOnce("AccessControlContext must not be null.", null);
                throw new SecurityException("AccessControlContext must not be null");
            }
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    try {
                        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                        if (classLoader == classLoader2) {
                            return classLoader2;
                        }
                        Thread.currentThread().setContextClassLoader(classLoader);
                        return classLoader2;
                    }
                    catch (SecurityException securityException) {
                        NotifFetcher.this.logOnce("Permission to set ContextClassLoader missing. Notifications will not be dispatched. Please check your Java policy configuration: " + securityException, securityException);
                        throw securityException;
                    }
                }
            }, accessControlContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ClassLoader classLoader = ClientNotifForwarder.this.defaultClassLoader != null ? this.setContextClassLoader(ClientNotifForwarder.this.defaultClassLoader) : null;
            try {
                this.doRun();
            }
            finally {
                if (ClientNotifForwarder.this.defaultClassLoader != null) {
                    this.setContextClassLoader(classLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            TargetedNotification[] targetedNotificationArray;
            Object object = ClientNotifForwarder.this;
            synchronized (object) {
                ClientNotifForwarder.this.currentFetchThread = Thread.currentThread();
                if (ClientNotifForwarder.this.state == 0) {
                    ClientNotifForwarder.this.setState(1);
                }
            }
            object = null;
            if (!this.shouldStop() && (object = this.fetchNotifs()) != null) {
                Integer n;
                HashMap<Integer, Object> hashMap;
                targetedNotificationArray = ((NotificationResult)object).getTargetedNotifications();
                int n2 = targetedNotificationArray.length;
                long l = 0L;
                Object object2 = ClientNotifForwarder.this;
                synchronized (object2) {
                    if (ClientNotifForwarder.this.clientSequenceNumber >= 0L) {
                        l = ((NotificationResult)object).getEarliestSequenceNumber() - ClientNotifForwarder.this.clientSequenceNumber;
                    }
                    ClientNotifForwarder.this.clientSequenceNumber = ((NotificationResult)object).getNextSequenceNumber();
                    int n3 = ClientNotifForwarder.this.infoList.size();
                    hashMap = new HashMap<Integer, Object>(n3 > n2 ? n2 : n3);
                    for (int i = 0; i < n2; ++i) {
                        Object object3;
                        TargetedNotification targetedNotification = targetedNotificationArray[i];
                        Integer n4 = targetedNotification.getListenerID();
                        if (!n4.equals(ClientNotifForwarder.this.mbeanRemovedNotifID)) {
                            object3 = (ListenerInfo)ClientNotifForwarder.this.infoList.get(n4);
                            if (object3 == null) continue;
                            hashMap.put(n4, object3);
                            continue;
                        }
                        object3 = targetedNotification.getNotification();
                        if (!(object3 instanceof MBeanServerNotification) || !((Notification)object3).getType().equals("JMX.mbean.unregistered")) continue;
                        MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)object3;
                        ObjectName objectName = mBeanServerNotification.getMBeanName();
                        ClientNotifForwarder.this.removeNotificationListener(objectName);
                    }
                    n = ClientNotifForwarder.this.mbeanRemovedNotifID;
                }
                if (l > 0L) {
                    object2 = "May have lost up to " + l + " notification" + (l == 1L ? "" : "s");
                    ClientNotifForwarder.this.lostNotifs((String)object2, l);
                    logger.trace("NotifFetcher.run", (String)object2);
                }
                for (int i = 0; i < n2; ++i) {
                    TargetedNotification targetedNotification = targetedNotificationArray[i];
                    this.dispatchNotification(targetedNotification, n, hashMap);
                }
            }
            targetedNotificationArray = ClientNotifForwarder.this;
            synchronized (ClientNotifForwarder.this) {
                ClientNotifForwarder.this.currentFetchThread = null;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                if (object == null || this.shouldStop()) {
                    ClientNotifForwarder.this.setState(3);
                    try {
                        ClientNotifForwarder.this.removeListenerForMBeanRemovedNotif(ClientNotifForwarder.this.mbeanRemovedNotifID);
                    }
                    catch (Exception exception) {}
                } else {
                    ClientNotifForwarder.this.executor.execute(this);
                }
                return;
            }
        }

        void dispatchNotification(TargetedNotification targetedNotification, Integer n, Map map) {
            Notification notification = targetedNotification.getNotification();
            Integer n2 = targetedNotification.getListenerID();
            if (n2.equals(n)) {
                return;
            }
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)map.get(n2);
            if (clientListenerInfo == null) {
                logger.trace("NotifFetcher.dispatch", "Listener ID not in map");
                return;
            }
            NotificationListener notificationListener = clientListenerInfo.getListener();
            Object object = clientListenerInfo.getHandback();
            try {
                notificationListener.handleNotification(notification, object);
            }
            catch (RuntimeException runtimeException) {
                logger.trace("NotifFetcher-run", "Failed to forward a notification to a listener", runtimeException);
            }
        }

        private NotificationResult fetchNotifs() {
            try {
                NotificationResult notificationResult = ClientNotifForwarder.this.fetchNotifs(ClientNotifForwarder.this.clientSequenceNumber, ClientNotifForwarder.this.maxNotifications, ClientNotifForwarder.this.timeout);
                if (logger.traceOn()) {
                    logger.trace("NotifFetcher-run", "Got notifications from the server: " + notificationResult);
                }
                return notificationResult;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.trace("NotifFetcher.fetchNotifs", classNotFoundException);
                return this.fetchOneNotif();
            }
            catch (NotSerializableException notSerializableException) {
                logger.trace("NotifFetcher.fetchNotifs", notSerializableException);
                return this.fetchOneNotif();
            }
            catch (IOException iOException) {
                if (!this.shouldStop()) {
                    logger.error("NotifFetcher-run", "Failed to fetch notification, stopping thread. Error is: " + iOException, iOException);
                    logger.debug("NotifFetcher-run", iOException);
                }
                return null;
            }
        }

        private NotificationResult fetchOneNotif() {
            Object object;
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            long l = ClientNotifForwarder.this.clientSequenceNumber;
            int n = 0;
            NotificationResult notificationResult = null;
            while (notificationResult == null && !this.shouldStop()) {
                try {
                    object = clientNotifForwarder.fetchNotifs(l, 0, 0L);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.warning("NotifFetcher.fetchOneNotif", "Impossible exception: " + classNotFoundException);
                    logger.debug("NotifFetcher.fetchOneNotif", classNotFoundException);
                    return null;
                }
                catch (IOException iOException) {
                    if (!this.shouldStop()) {
                        logger.trace("NotifFetcher.fetchOneNotif", iOException);
                    }
                    return null;
                }
                if (this.shouldStop()) {
                    return null;
                }
                l = ((NotificationResult)object).getNextSequenceNumber();
                try {
                    notificationResult = clientNotifForwarder.fetchNotifs(l, 1, 0L);
                }
                catch (Exception exception) {
                    if (exception instanceof ClassNotFoundException || exception instanceof NotSerializableException) {
                        logger.warning("NotifFetcher.fetchOneNotif", "Failed to deserialize a notification: " + exception.toString());
                        if (logger.traceOn()) {
                            logger.trace("NotifFetcher.fetchOneNotif", "Failed to deserialize a notification.", exception);
                        }
                        ++n;
                        ++l;
                        continue;
                    }
                    if (!this.shouldStop()) {
                        logger.trace("NotifFetcher.fetchOneNotif", exception);
                    }
                    return null;
                }
            }
            if (n > 0) {
                object = "Dropped " + n + " notification" + (n == 1 ? "" : "s") + " because classes were missing locally";
                ClientNotifForwarder.this.lostNotifs((String)object, n);
            }
            return notificationResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shouldStop() {
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            synchronized (clientNotifForwarder) {
                if (ClientNotifForwarder.this.state != 1) {
                    return true;
                }
                if (ClientNotifForwarder.this.infoList.size() == 0) {
                    ClientNotifForwarder.this.setState(2);
                    return true;
                }
                return false;
            }
        }
    }
}

