/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import javax.management.openmbean.CompositeData;
import sun.management.ManagementFactory;
import sun.management.ThreadInfoCompositeData;

public class ThreadInfo {
    private final String threadName;
    private final long threadId;
    private final long blockedTime;
    private final long blockedCount;
    private final long waitedTime;
    private final long waitedCount;
    private final String lockName;
    private final long lockOwnerId;
    private final String lockOwnerName;
    private final boolean inNative;
    private final boolean suspended;
    private final Thread.State threadState;
    private final StackTraceElement[] stackTrace;
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];

    private ThreadInfo(Thread thread, int n, Object object, Thread thread2, long l, long l2, long l3, long l4, StackTraceElement[] stackTraceElementArray) {
        this.threadId = thread.getId();
        this.threadName = thread.getName();
        this.threadState = ManagementFactory.toThreadState(n);
        this.suspended = ManagementFactory.isThreadSuspended(n);
        this.inNative = ManagementFactory.isThreadRunningNative(n);
        this.blockedCount = l;
        this.blockedTime = l2;
        this.waitedCount = l3;
        this.waitedTime = l4;
        this.lockName = object == null ? null : object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
        if (thread2 == null) {
            this.lockOwnerId = -1L;
            this.lockOwnerName = null;
        } else {
            this.lockOwnerId = thread2.getId();
            this.lockOwnerName = thread2.getName();
        }
        this.stackTrace = stackTraceElementArray;
    }

    private ThreadInfo(CompositeData compositeData) {
        ThreadInfoCompositeData.validateCompositeData(compositeData);
        this.threadId = ThreadInfoCompositeData.getThreadId(compositeData);
        this.threadName = ThreadInfoCompositeData.getThreadName(compositeData);
        this.blockedTime = ThreadInfoCompositeData.getBlockedTime(compositeData);
        this.blockedCount = ThreadInfoCompositeData.getBlockedCount(compositeData);
        this.waitedTime = ThreadInfoCompositeData.getWaitedTime(compositeData);
        this.waitedCount = ThreadInfoCompositeData.getWaitedCount(compositeData);
        this.lockName = ThreadInfoCompositeData.getLockName(compositeData);
        this.lockOwnerId = ThreadInfoCompositeData.getLockOwnerId(compositeData);
        this.lockOwnerName = ThreadInfoCompositeData.getLockOwnerName(compositeData);
        this.threadState = ThreadInfoCompositeData.getThreadState(compositeData);
        this.suspended = ThreadInfoCompositeData.isSuspended(compositeData);
        this.inNative = ThreadInfoCompositeData.isInNative(compositeData);
        this.stackTrace = ThreadInfoCompositeData.getStackTrace(compositeData);
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            return NO_STACK_TRACE;
        }
        return this.stackTrace;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public String toString() {
        return "Thread " + this.getThreadName() + " (Id = " + this.getThreadId() + ") " + (Object)((Object)this.getThreadState()) + " " + this.getLockName();
    }

    public static ThreadInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof ThreadInfoCompositeData) {
            return ((ThreadInfoCompositeData)compositeData).getThreadInfo();
        }
        return new ThreadInfo(compositeData);
    }
}

