/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;

public class RoleInfo
implements Serializable {
    private static final long oldSerialVersionUID = 7227256952085334351L;
    private static final long newSerialVersionUID = 2504952983494636987L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myName", String.class), new ObjectStreamField("myIsReadableFlg", Boolean.TYPE), new ObjectStreamField("myIsWritableFlg", Boolean.TYPE), new ObjectStreamField("myDescription", String.class), new ObjectStreamField("myMinDegree", Integer.TYPE), new ObjectStreamField("myMaxDegree", Integer.TYPE), new ObjectStreamField("myRefMBeanClassName", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", String.class), new ObjectStreamField("isReadable", Boolean.TYPE), new ObjectStreamField("isWritable", Boolean.TYPE), new ObjectStreamField("description", String.class), new ObjectStreamField("minDegree", Integer.TYPE), new ObjectStreamField("maxDegree", Integer.TYPE), new ObjectStreamField("referencedMBeanClassName", String.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    public static int ROLE_CARDINALITY_INFINITY;
    private String name = null;
    private boolean isReadable;
    private boolean isWritable;
    private String description = null;
    private int minDegree;
    private int maxDegree;
    private String referencedMBeanClassName = null;

    public RoleInfo(String string, String string2, boolean bl, boolean bl2, int n, int n2, String string3) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        this.init(string, string2, bl, bl2, n, n2, string3);
    }

    public RoleInfo(String string, String string2, boolean bl, boolean bl2) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.init(string, string2, bl, bl2, 1, 1, null);
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {
            // empty catch block
        }
    }

    public RoleInfo(String string, String string2) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.init(string, string2, true, true, 1, 1, null);
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {
            // empty catch block
        }
    }

    public RoleInfo(RoleInfo roleInfo) throws IllegalArgumentException {
        if (roleInfo == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        try {
            this.init(roleInfo.getName(), roleInfo.getRefMBeanClassName(), roleInfo.isReadable(), roleInfo.isWritable(), roleInfo.getMinDegree(), roleInfo.getMaxDegree(), roleInfo.getDescription());
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public String getRefMBeanClassName() {
        return this.referencedMBeanClassName;
    }

    public boolean checkMinDegree(int n) {
        return n >= ROLE_CARDINALITY_INFINITY && (this.minDegree == ROLE_CARDINALITY_INFINITY || n >= this.minDegree);
    }

    public boolean checkMaxDegree(int n) {
        return n >= ROLE_CARDINALITY_INFINITY && (this.maxDegree == ROLE_CARDINALITY_INFINITY || n != ROLE_CARDINALITY_INFINITY && n <= this.maxDegree);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("role info name: " + this.name);
        stringBuffer.append("; isReadable: " + this.isReadable);
        stringBuffer.append("; isWritable: " + this.isWritable);
        stringBuffer.append("; description: " + this.description);
        stringBuffer.append("; minimum degree: " + this.minDegree);
        stringBuffer.append("; maximum degree: " + this.maxDegree);
        stringBuffer.append("; MBean class: " + this.referencedMBeanClassName);
        return stringBuffer.toString();
    }

    private void init(String string, String string2, boolean bl, boolean bl2, int n, int n2, String string3) throws IllegalArgumentException, InvalidRoleInfoException {
        if (string == null || string2 == null) {
            String string4 = "Invalid parameter.";
            throw new IllegalArgumentException(string4);
        }
        this.name = string;
        this.isReadable = bl;
        this.isWritable = bl2;
        if (string3 != null) {
            this.description = string3;
        }
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 != ROLE_CARDINALITY_INFINITY && (n == ROLE_CARDINALITY_INFINITY || n > n2)) {
            stringBuffer.append("Minimum degree ");
            stringBuffer.append(n);
            stringBuffer.append(" is greater than maximum degree ");
            stringBuffer.append(n2);
            bl3 = true;
        } else if (n < ROLE_CARDINALITY_INFINITY || n2 < ROLE_CARDINALITY_INFINITY) {
            stringBuffer.append("Minimum or maximum degree has an illegal value, must be [0, ROLE_CARDINALITY_INFINITY].");
            bl3 = true;
        }
        if (bl3) {
            throw new InvalidRoleInfoException(stringBuffer.toString());
        }
        this.minDegree = n;
        this.maxDegree = n2;
        this.referencedMBeanClassName = string2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.name = (String)getField.get("myName", null);
            if (getField.defaulted("myName")) {
                throw new NullPointerException("myName");
            }
            this.isReadable = getField.get("myIsReadableFlg", false);
            if (getField.defaulted("myIsReadableFlg")) {
                throw new NullPointerException("myIsReadableFlg");
            }
            this.isWritable = getField.get("myIsWritableFlg", false);
            if (getField.defaulted("myIsWritableFlg")) {
                throw new NullPointerException("myIsWritableFlg");
            }
            this.description = (String)getField.get("myDescription", null);
            if (getField.defaulted("myDescription")) {
                throw new NullPointerException("myDescription");
            }
            this.minDegree = getField.get("myMinDegree", 0);
            if (getField.defaulted("myMinDegree")) {
                throw new NullPointerException("myMinDegree");
            }
            this.maxDegree = getField.get("myMaxDegree", 0);
            if (getField.defaulted("myMaxDegree")) {
                throw new NullPointerException("myMaxDegree");
            }
            this.referencedMBeanClassName = (String)getField.get("myRefMBeanClassName", null);
            if (getField.defaulted("myRefMBeanClassName")) {
                throw new NullPointerException("myRefMBeanClassName");
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("myName", this.name);
            putField.put("myIsReadableFlg", this.isReadable);
            putField.put("myIsWritableFlg", this.isWritable);
            putField.put("myDescription", this.description);
            putField.put("myMinDegree", this.minDegree);
            putField.put("myMaxDegree", this.maxDegree);
            putField.put("myRefMBeanClassName", this.referencedMBeanClassName);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = (String)AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 7227256952085334351L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 2504952983494636987L;
        }
        ROLE_CARDINALITY_INFINITY = -1;
    }
}

