/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class EnumGen
implements com.sun.tools.corba.se.idl.EnumGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected EnumEntry e = null;
    protected PrintWriter stream = null;
    String className = null;
    String fullClassName = null;

    public void generate(Hashtable hashtable, EnumEntry enumEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.e = enumEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateHolder();
        this.generateHelper();
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.className = this.e.name();
        this.fullClassName = Util.javaName(this.e);
    }

    protected void openStream() {
        this.stream = Util.stream(this.e, ".java");
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.e);
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.e);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.e);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.e.comment() != null) {
            this.e.comment().generate("", this.stream);
        }
        this.stream.println("public class " + this.className + " implements org.omg.CORBA.portable.IDLEntity");
        this.stream.println("{");
    }

    protected void writeBody() {
        this.stream.println("  private        int __value;");
        this.stream.println("  private static int __size = " + this.e.elements().size() + ';');
        this.stream.println("  private static " + this.fullClassName + "[] __array = new " + this.fullClassName + " [__size];");
        this.stream.println();
        for (int i = 0; i < this.e.elements().size(); ++i) {
            String string = (String)this.e.elements().elementAt(i);
            this.stream.println("  public static final int _" + string + " = " + i + ';');
            this.stream.println("  public static final " + this.fullClassName + ' ' + string + " = new " + this.fullClassName + "(_" + string + ");");
        }
        this.stream.println();
        this.writeValue();
        this.writeFromInt();
        this.writeCtors();
    }

    protected void writeValue() {
        this.stream.println("  public int value ()");
        this.stream.println("  {");
        this.stream.println("    return __value;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeFromInt() {
        this.stream.println("  public static " + this.fullClassName + " from_int (int value)");
        this.stream.println("  {");
        this.stream.println("    if (value >= 0 && value < __size)");
        this.stream.println("      return __array[value];");
        this.stream.println("    else");
        this.stream.println("      throw new org.omg.CORBA.BAD_PARAM ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeCtors() {
        this.stream.println("  protected " + this.className + " (int value)");
        this.stream.println("  {");
        this.stream.println("    __value = value;");
        this.stream.println("    __array[__value] = this;");
        this.stream.println("  }");
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.className);
    }

    protected void closeStream() {
        this.stream.close();
    }

    public int helperType(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        tCOffsets.set(symtabEntry);
        EnumEntry enumEntry = (EnumEntry)symtabEntry;
        StringBuffer stringBuffer = new StringBuffer("new String[] { ");
        Enumeration enumeration = enumEntry.elements().elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append('\"' + Util.stripLeadingUnderscores((String)enumeration.nextElement()) + '\"');
        }
        stringBuffer.append("} ");
        printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().create_enum_tc (" + Util.helperName(enumEntry, true) + ".id (), \"" + Util.stripLeadingUnderscores(symtabEntry.name()) + "\", " + new String(stringBuffer) + ");");
        return n + 1;
    }

    public int type(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n;
    }

    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    return " + Util.javaQualifiedName(symtabEntry) + ".from_int (istream.read_long ());");
    }

    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    ostream.write_long (value.value ());");
    }

    public int read(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.javaQualifiedName(symtabEntry) + ".from_int (istream.read_long ());");
        return n;
    }

    public int write(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + "ostream.write_long (" + string2 + ".value ());");
        return n;
    }
}

