title: 動物システム(1)

動物システム(1)
========================================

プロダクションシステムの説明をするときの定番の
例である動物システムを作ってみる．典型的な
プロダクションシステムをそのまま，Jenaに移植
するという方針で作ってみる．(フレームシステム
もどきのシステムは[こちら](./animal2.mm)で，
もっとセマンティックウェブの特徴を取り入れた
ものは[こちら](./animal3.mm)で取り上げる)

動物システムで使用する特別な述語として
「:p」を採用する．この述語(プロパティ)は主語は
目的語を持つとか，目的語の表す性質を持つという
意味を表す．

(?x :p :牙) : ?xは牙を持つ．
(?x :p :授乳) : ?xは授乳する性質を持つ

もうひとつ名前を表すプロパティ「:name」を
使うこととする．

(?x :name 'ライオン') : ?xの名前は'ライオン'である．

-----

否定を表すビルトイン

    noValue(?x, ?p)
    noValue(?x ?p ?v)

-----

1. もし体毛を持つならば，それは哺乳動物である．
2. もし授乳するならば，それは哺乳動物である．
3. もし飛ぶことができ，産卵するならば，それは鳥である．
4. もし羽を持ち，ペンギンでないならばそれは飛ぶ．
5. もし哺乳動物であり，肉食ならば，それは肉食動物である．
6. もし哺乳動物であり，鋭い歯をもち，かつ鋭い爪をもつならば，
   それは肉食動物である．
7. もし哺乳動物であり，蹄を持つならば，それは有蹄動物である．
8. もし肉食動物であり，黄褐色で，かつ黒い縞をもつならば，それはトラである．
9. もし肉食動物であり，黄褐色で，かつ黒い斑点をもつならば，それはチータである．
10. もし有蹄動物であり，黄褐色で，かつ黒い斑点をもつならば，それはキリンである．
11. 名前が出たら画面に表示せよ．

-----

    # 動物システム
    @prefix : <http://test.org/> .
      (?x :p :体毛) -> (?x :p :哺乳動物) .
      (?x :p :授乳) -> (?x :p :哺乳動物) .
      (?x :p :飛ぶ), (?x :p :産卵) -> (?x :p :鳥) .
      (?x :p :羽), noValue(?x :name 'ペンギン') -> (?x :p :飛ぶ) .
      (?x :p :哺乳動物), (?x :p :肉食) -> (?x :p :肉食動物) .
      (?x :p :哺乳動物), (?x :p :鋭い歯), (?x :p :鋭い爪) -> (?x :p :肉食動物) .
      (?x :p :哺乳動物), (?x :p :蹄) -> (?x :p :有蹄動物) .
      (?x :p :肉食動物), (?x :p :黄褐色), (?x :p :黒い縞) -> (?x :name 'トラ') .
      (?x :p :肉食動物), (?x :p :黄褐色), (?x :p :黒い斑点) -> (?x :name 'チータ') .
      (?x :p :有蹄動物), (?x :p :黄褐色), (?x :p :黒い斑点) -> (?x :name 'キリン') .
      (?x :name ?y) -> print(?y) .


-----

次のNotation3で前向き推論を実行できる．

    # 動物システム質問
    # 「体毛があり鋭い歯と爪をもち，かつ黄褐色で黒い斑点を持つ動物はなにか？」
    @prefix : <http://test.org/> .
      :ans :p :体毛 ,
              :鋭い歯 ,
              :鋭い爪 ,
              :黄褐色 ,
              :黒い斑点 .

-----

JenaCheckは，推論エンジンを前向き推論と後向き推論の
ハイブリッドモードにしているため，あまり意味はないのだが，
次のようにして，一応後向き推論もためせる．最初にN3のデータを入れておき，
SPARQLのASKクエリを実行する．でも，実はN3を入れた段階で
「トラ」と出てきてしまう．(エンジンが後向き推論だけのモードの場合には
意味はある．また，Jenaを生で使う場合は，クエリが実行されるまで
推論が行われないので，これも意味はある．)


    # 動物システム質問
    # 「肉食で，黄褐色かつ黒い縞をもち，授乳する動物はトラだろうか？」
    # の条件の部分．
    @prefix : <http://test.org/> .
      :ans :p :肉食 ,
              :黄褐色 ,
              :黒い縞 ,
              :授乳 .

    # 動物システム質問
    # 「肉食で，黄褐色かつ黒い縞をもち，授乳する動物はトラだろうか？」
    # の仮説を問う部分．
    PREFIX : <http://test.org/>
    ASK { :ans :name 'トラ' }

-----

