title: 動物システム(3)

動物システム(3)
========================================

* [プロダクションシステム](./animal1.mm)
* [フレームシステムもどき](./animal2.mm)

動物システムオントロジー
----------------------------------------

以下の内容を実行する前に
JenaCheckでOWL-DLの機能を有効にするために，
「OWL-DL」チェックボックスをONにして下さい．

以下が動物システムのオントロジーです．

    @prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .
    @prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .
    @prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix owl:     <http://www.w3.org/2002/07/owl#> .
    @prefix :        <http://test.org/> .

    :           a owl:Ontology .
    :動物の行動 a owl:Class .
    :動物の部位 a owl:Class .
    :飛ぶ       a :動物の行動 .
    :飛ばない   a :動物の行動 .
    :産卵       a :動物の行動 .
    :肉食       a :動物の行動 .
    :授乳       a :動物の行動 .
    :体毛       a :動物の部位 .
    :鋭い歯     a :動物の部位 .
    :黒い縞     a :動物の部位 .
    :黄褐色     a :動物の部位 .
    :羽         a :動物の部位 .
    :蹄         a :動物の部位 .
    :黒い斑点   a :動物の部位 .
    :鋭い爪     a :動物の部位 .

    #動物システムで使う2つの述語(doとapo)
    :do   a       owl:ObjectProperty ;
          rdfs:domain :動物 ;
          rdfs:range :動物の行動 .

    :apo  a       owl:ObjectProperty ;
          rdfs:domain :動物 ;
          rdfs:range :動物の部位 .

    #以下動物システムのクラス階層

    :動物       a owl:Class .

    :哺乳動物
          a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf ([ a       owl:Restriction ;
                                owl:hasValue :授乳 ;
                                owl:onProperty :do
                              ] [ a       owl:Restriction ;
                                owl:hasValue :体毛 ;
                                owl:onProperty :apo
                              ] :動物)
                  ] .

    :肉食動物
          a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf (:哺乳動物 [ a       owl:Restriction ;
                                owl:hasValue :鋭い歯 ;
                                owl:onProperty :apo
                              ] [ a       owl:Restriction ;
                                owl:hasValue :鋭い爪 ;
                                owl:onProperty :apo
                              ] [ a       owl:Restriction ;
                                owl:hasValue :肉食 ;
                                owl:onProperty :do
                              ])
                  ] .

    :トラ   a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf (:肉食動物 [ a       owl:Restriction ;
                                owl:hasValue :黄褐色 ;
                                owl:onProperty :apo
                              ] [ a       owl:Restriction ;
                                owl:hasValue :黒い縞 ;
                                owl:onProperty :apo
                              ])
                  ] .

    :チータ  a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf (:肉食動物 [ a       owl:Restriction ;
                                owl:hasValue :黄褐色 ;
                                owl:onProperty :apo
                              ] [ a       owl:Restriction ;
                                owl:hasValue :黒い斑点 ;
                                owl:onProperty :apo
                              ])
                  ] .

    :有蹄動物
          a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf (:哺乳動物 [ a       owl:Restriction ;
                                owl:hasValue :蹄 ;
                                owl:onProperty :apo
                              ])
                  ] .

    :キリン  a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf (:有蹄動物 [ a       owl:Restriction ;
                                owl:hasValue :黒い斑点 ;
                                owl:onProperty :apo
                              ] [ a       owl:Restriction ;
                                owl:hasValue :黄褐色 ;
                                owl:onProperty :apo
                              ])
                  ] .

    :鳥    a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf (:動物 [ a       owl:Restriction ;
                                owl:hasValue :羽 ;
                                owl:onProperty :apo
                              ] [ a       owl:Restriction ;
                                owl:hasValue :産卵 ;
                                owl:onProperty :do
                              ])
                  ] .

    :飛ぶ鳥  a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf (:鳥 [ a       owl:Restriction ;
                                owl:hasValue :飛ぶ ;
                                owl:onProperty :do
                              ])
                  ] .

    :飛ばない鳥
          a       owl:Class ;
          owl:equivalentClass
                  [ a       owl:Class ;
                    owl:intersectionOf (:鳥 [ a       owl:Restriction ;
                                owl:hasValue :飛ばない ;
                                owl:onProperty :do
                              ])
                  ] .

    :ペンギン
          a       owl:Class ;
          rdfs:subClassOf :飛ばない鳥 .

    #おまけで，実在する動物のデータを入れておく
    #岩手の釜石市で飼われているキングペンギン
    :ペンちゃん    a   :ペンギン .
    #朝日山動物園のトラ(メス)
    :のん   a   :トラ .

質問をする
----------------------------------------

上のオントロジーをNotation3に入れて追加した後，
以下の質問をしてみる．

ペンちゃんは飛びますか？

    PREFIX : <http://test.org/>
    ASK { :ペンちゃん :do :飛ぶ }

のんの持つ性質は？

    PREFIX : <http://test.org/>
    SELECT *
    WHERE { :のん ?y ?z }


* <http://www.yamaguti.comp.ae.keio.ac.jp/japanese/2006%E7%9F%A5%E8%AD%98%E3%82%B7%E3%82%B9%E3%83%86%E3%83%A0%E8%AB%96/protege_%E6%BC%94%E7%BF%92.ppt>

