title: FSMの拡張出力処理(通信)
css: test.css

FSMの拡張出力処理(通信)
----------------------------------------

通信を実現するためのルールも一緒に使う必要があります．
[communication.mm](../communication.mm)．

    @prefix fsm: <http://fsm.org/> .
    @prefix co: <http://communication.org/> .
    @prefix cf: <http://communication.org/fsm/> .
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    #co:send send_n3を使って単純に三つ組を送るだけの通信
    #とりあえず．三つ組を一つしか送れません．
    #第一引数:SEP，第二引数:主語，第3引数:述語，第4引数:目的語
    #SEPと目的語はFSMの変数名を指定することになってます．
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b cf:send ?list)
    (?b fsm:target_fsm ?fsm)
    #listEntry(?list,0,?sepVar)
    #listEntry(?list,1,?s)
    #listEntry(?list,2,?p)
    #listEntry(?list,3,?oVar)
    (?list rdf:first ?sepVar)
    (?list rdf:rest ?rest1)
    (?rest1 rdf:first ?s)
    (?rest1 rdf:rest ?rest2)
    (?rest2 rdf:first ?p)
    (?rest2 rdf:rest ?rest3)
    (?rest3 rdf:first ?oVar)
    (?fsm fsm:var ?b1)
    (?b1 ?sepVar ?sep)
    noValue(?b1 fsm:is fsm:old)
    (?fsm fsm:var ?b2)
    (?b2 ?oVar ?o)
    noValue(?b2 fsm:is fsm:old)
    makeTemp(?ib)
        ->
        send_n3(?sep,?s,?p,?o)
        (?b fsm:is fsm:fin)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .
    #co:request co:のルールを使って送受信
    #引数1:SEP，引数2:reqName，引数3:rep，引数4:arg1，引数5:arg2，引数6:arg3
    #reqName以外はFSMの変数名を指定するようになってます．
    #repが返事を保存する変数名
    #arg1,2,3が送信する内容が保存された変数名
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b cf:request ?list)
    (?b fsm:target_fsm ?fsm)
    #listEntry(?list,0,?sepVar)
    #listEntry(?list,1,?reqName)
    #listEntry(?list,2,?repVar)
    #listEntry(?list,3,?arg1Var)
    #listEntry(?list,4,?arg2Var)
    #listEntry(?list,5,?arg3Var)
    (?list rdf:first ?sepVar)
    (?list rdf:rest ?rest1)
    (?rest1 rdf:first ?reqName)
    (?rest1 rdf:rest ?rest2)
    (?rest2 rdf:first ?rep)
    (?rest2 rdf:rest ?rest3)
    (?rest3 rdf:first ?arg1Var)
    (?rest3 rdf:rest ?rest4)
    (?rest4 rdf:first ?arg2Var)
    (?rest4 rdf:rest ?rest5)
    (?rest5 rdf:first ?arg3Var)
    (?fsm fsm:var ?b1)
    (?b1 ?sepVar ?sep)
    noValue(?b1 fsm:is fsm:old)
    (?fsm fsm:var ?b2)
    (?b2 ?arg1Var ?arg1)
    noValue(?b2 fsm:is fsm:old)
    (?fsm fsm:var ?b3)
    (?b3 ?arg2Var ?arg2)
    noValue(?b3 fsm:is fsm:old)
    (?fsm fsm:var ?b4)
    (?b4 ?arg3Var ?arg3)
    noValue(?b4 fsm:is fsm:old)
    makeTemp(?r)
    makeTemp(?tmp)
        ->
        (?tmp cf:targetFSM ?fsm)
        (?tmp cf:targetVar ?rep)
        (?r rdf:type co:RequestClient)
        (?r co:server ?sep)
        (?r co:reqName ?reqName)
        (?r co:catchName cf:catch)
        (?r co:arg1 ?arg1)
        (?r co:arg2 ?arg2)
        (?r co:arg3 ?arg3)
        (?b fsm:is fsm:fin)
        .
    #返事を受け取ってFSMの変数に代入するルール
    (cf:catch co:rep ?x)
    (?b cf:targetFSM ?fsm)
    (?b cf:targetVar ?var)
    noValue(?b,cf:is,cf:old)
    makeTemp(?vb)
    makeTemp(?ib)
        ->
        (?b cf:is cf:old)
        (?fsm fsm:var ?vb)
        (?vb ?var ?x)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .

確認のためのサーバルール．サーバ側にも
[communication.mm](../communication.mm)のルールは必要です．

    @prefix : <http://test.org/> .
    @prefix co: <http://communication.org/> .
    #テストのルール(うけとった数字に10を加えて返す)
    (:test co:reqs ?reqs),
    (:test co:arg1 ?x)
    sum(?x,10,?xNew) ->
        (:tRep rdf:type co:ReplyServer),
        (:tRep co:reqs ?reqs),
        (:tRep co:rep ?xNew) .

確認のためのFSM

    @prefix : <http://test.org/> .
    @prefix fsm: <http://fsm.org/> .
    @prefix co: <http://communication.org/> .
    @prefix cf: <http://communication.org/fsm/> .
    #FSM1の定義と初期化
    :FSM1 a             fsm:fsm ;
          fsm:status    [ fsm:status :start ] ;
          fsm:input     [ fsm:input 'goNext' ] ;
          fsm:var       [ :sep 'http://192.168.2.15:8080/axis2/services/JEService' ],
                        [ :var1 10 ],
                        [ :var2 'dummy' ],
                        [ :var3 'dummy' ] ;
          fsm:inputList [ fsm:status :start;
                          fsm:list ('goNext') ] ,
                        [ fsm:status :a;
                          fsm:list ('A') ] ,
                        [ fsm:status :b;
                          fsm:list ('@finished@') ] ,
                        [ fsm:status :c;
                          fsm:list () ] .
    #三組入力をFSM1にバインド
    fsm:tripleInput fsm:bindto :FSM1 .
    #FSM1の状態遷移表の定義
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :start;
      fsm:input       'goNext' ;
      fsm:output      (cf:send (:sep :a :b :var1)) ;
      fsm:next_status :a ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a ;
      fsm:input       'A' ;
      fsm:output      (cf:request (:sep :test :testVar :var1 :var2 :var3)) ;
      fsm:next_status :b ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :b ;
      fsm:input       '@finished@' ;
      fsm:output      (fsm:varPrint :testVar) ;
      fsm:next_status :c ] .
