title: FSMの使い方(出力処理)
css: test.css

FSMの使い方(出力処理)
----------------------------------------

### FSMの変数

出力処理の説明に入る前に，出力処理で使用する
変数について説明しておきます．普通FSMでは
変数というものを考えませんが，ここで紹介する
FSMは変数(のようなもの)を使用できるようにして
あります．

変数名はURIにより指定されます．デフォルトの
ネームスペースを指定しているならば「:x」や
「:y」，「:var」，「:tempVar」のような
指定が可能です．

この変数は，FSMごとに固有のもので，他のFSMで
同じ変数名を使用しても区別されます．

変数に値を代入しておけば，後でその値を様々な
処理で使用することができるようになっています．

すでに値が代入されている変数に，もう一度代入
をすると，一つの変数に二つの値が設定される
こととなり変数の読み出しで期待した値が取り出さ
れない可能性が出てきます．

変数の値を変更したい場合は，一旦変数を消去
して，それから新しく代入しなおして下さい．
(なので，変数と呼ぶのはおかしいかもしれない
です…)

### 出力処理の種類

[FSMの使い方(基本)](./usage1.mm)で見たように，
fsm:outputの目的語の部分に出力処理を記述します．
デフォルトで使用できる出力処理は以下のものとなります．

* [fsm:nop]なにもしない
* [fsm:print]単純文字出力
* [fsm:read]文字入力
* [fsm:varPrint]変数を出力
* [fsm:bind]変数に代入
* [fsm:unbind]変数を消去

このデフォルトの出力処理以外の処理は，用途ごとに以下の
ページで解説しています．

* [FSMの拡張出力処理(通信)](./output1.mm)
* [FSMの拡張出力処理(A3)](./output1.mm)

また，これらの出力処理でまにあわない場合は
[こちら](./usage4.mm)で説明するように，
自分で出力処理を定義して使用することもできます．

以下一つ一つについて少し詳しく解説します．

#### fsm:nop

何も行わずに，状態遷移だけしたい時に指定する出力処理．
引数にはダミーの何かを指定しておいて下さい．

    fsm:output (fsm:nop 'dummy') ;

#### fsm:print

単純文字出力．引数で指定した値を標準出力に出力します．

    fsm:output (fsm:print 'Hello World!') ;

#### fsm:read

文字入力．三組入力で入力された値を引数で指定した変数に
代入します．この機能を使用するには

    @prefix fsm: <http://fsm.org/> .
    fsm:tripleInput fsm:bindto FSMのインスタンス .

という設定をする必要があります．上の`FSMのインスタンス`の
部分には実際に利用するFSMのURIを指定して下さい．(例えば
:FSM1など)

    fsm:output (fsm:read :testVar) ;

#### fsm:varPrint

変数を出力．引数で指定した変数の内容を標準出力に
出力します．

    fsm:output (fsm:varPrint :testVar) ;

#### fsm:bind

変数に代入．指定した引数に値を代入します．変数名と
値の二つの引数が必要ですが，このように複数の引数が
必要な場合には以下のように，リストとして一つに
まとめて記述します．

    fsm:output (fsm:bind (:testVar 'some value')) ;

#### fsm:unbind

変数を消去．変数を消去します．どうしても変数の
内容を書換えたい場合には，このfsm:unbindを使って，
変数を一旦消去してから，fsm:bindで代入する必要が
あります．

    fsm:output (fsm:unbind :testVar) ;

