title: FSMの使い方(簡単な例)
css: test.css

FSMの使い方(簡単な例)
----------------------------------------

    #県庁所在地の知識(Notation3)
    @prefix : <http://test.org/> .
    :北海道 :文字列 '北海道' ;
            :県庁所在地 :札幌 .
    :札幌   :文字列 '札幌' .
    :愛知   :文字列 '愛知' ;
            :県庁所在地 :名古屋 .
    :名古屋 :文字列 '名古屋' .

県庁所在地を求めるルールを作成します．

    @prefix : <http://test.org/> .
    @prefix fsm: <http://fsm.org/> .
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    #:kencho(1) 都道府県から県庁所在地を取り出す．
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b :kencho ?list)
    (?b fsm:target_fsm ?fsm)
    #listEntry(?list,0,?var0)
    #listEntry(?list,1,?var1)
    (?list rdf:first ?var0)
    (?list rdf:rest ?rest1)
    (?rest1 rdf:first ?var1)
    (?fsm fsm:var ?vb)
    noValue(?vb fsm:is fsm:old)
    (?vb ?var0 ?todoufuken)
    (?tmp1 :文字列 ?todoufuken)
    (?tmp1 :県庁所在地 ?tmp2)
    (?tmp2 :文字列 ?kencho)
    makeTemp(?ib)
    makeTemp(?vb2)
        ->
        (?fsm fsm:var ?vb2)
        (?vb2 ?var1 ?kencho)
        (?b fsm:is fsm:fin)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .
    #:kencho(2) 確答データが無い場合
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b :kencho ?list)
    (?b fsm:target_fsm ?fsm)
    #listEntry(?list,0,?var0)
    #listEntry(?list,1,?var1)
    (?list rdf:first ?var0)
    (?list rdf:rest ?rest1)
    (?rest1 rdf:first ?var1)
    (?fsm fsm:var ?vb)
    noValue(?vb fsm:is fsm:old)
    (?vb ?var0 ?todoufuken)
    noValue(?tmp1 :文字列 ?todoufuken)
    makeTemp(?ib)
    makeTemp(?vb2)
        ->
        (?fsm fsm:var ?vb2)
        (?vb2 ?var1 'データベースにデータがありません．')
        (?b fsm:is fsm:fin)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .

状態遷移に関する情報は以下になります．

<!--
<embed src="images/sampleFSM.svg" type="image/svg+xml" width="300" height="150" />
-->

![sampleFSM.png](./images/sampleFSM.png)

    @prefix : <http://test.org/> .
    @prefix fsm: <http://fsm.org/> .
    @prefix a3: <http://elm-ve.sf.net/a23/a3/fsm/> .
    #FSM1の定義と初期化
    :FSM1 a             fsm:fsm ;
          fsm:status    [ fsm:status :start ] ;
          fsm:input     [ fsm:input 'goNext' ] ;
          fsm:inputList [ fsm:status :start;
                          fsm:list ('goNext') ] ,
                        [ fsm:status :a1;
                          fsm:list ('@finished@') ] ,
                        [ fsm:status :a2;
                          fsm:list ('@finished@') ] ,
                        [ fsm:status :a3;
                          fsm:list ('@finished@') ] ,
                        [ fsm:status :a4;
                          fsm:list ('@finished@') ] ,
                        [ fsm:status :a5;
                          fsm:list ('@finished@') ] ,
                        [ fsm:status :a6;
                          fsm:list ('@finished@') ] ,
                        [ fsm:status :a7;
                          fsm:list ('@finished@') ] .
    #三組入力をFSM1にバインド
    fsm:tripleInput fsm:bindto :FSM1 .
    #FSM1の状態遷移表の定義
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :start;
      fsm:input       'goNext' ;
      fsm:output      (a3:init (:w 'x-res:///jp/ac/do_johodai/j314/sw/jc/vesma9.a3')) ;
      fsm:next_status :a1 ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a1 ;
      fsm:input       '@finished@' ;
      fsm:output      (a3:print (:w '都道府県を入力して下さい．')) ;
      fsm:next_status :a2 ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a2 ;
      fsm:input       '@finished@' ;
      fsm:output      (fsm:read :todoufuken) ;
      fsm:next_status :a3 ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a3 ;
      fsm:input       '@finished@' ;
      fsm:output      (:kencho (:todoufuken :kencho)) ;
      fsm:next_status :a4 ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a4 ;
      fsm:input       '@finished@' ;
      fsm:output      (a3:varPrint (:w :kencho)) ;
      fsm:next_status :a5 ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a5 ;
      fsm:input       '@finished@' ;
      fsm:output      (fsm:unbind :todoufuken) ;
      fsm:next_status :a6 ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a6 ;
      fsm:input       '@finished@' ;
      fsm:output      (fsm:unbind :kencho) ;
      fsm:next_status :a7 ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a7 ;
      fsm:input       '@finished@' ;
      fsm:output      (fsm:read :dummy) ;
      fsm:next_status :a1 ] .
