title: リスト処理

リスト処理
========================================

Jenaのビルトイン
----------------------------------------

* listContains(?list, ?val)
  - listにvalが含まれればtrue
* listEntry(?list, ?index, ?val)
  - listのindex番目をvalに代入
* listEqual(?list1, ?list2)
  - list1とlist2が等しければtrue
* listLength(?list, ?len)
  - listの長さをlenに代入
* listMapAsObject(?s, ?p, ?list)
  - 主語が?sで述語が?pの三つ組を大量生成
* listMapAsSubject(?list, ?p, ?o)
  - 述語が?pで目的語が?oの三つ組を大量生成
* listNotContains(?list, ?val)
  - listにvalが含まれればfalse
* listNotEqual(list1, ?list2)
  - list1とlist2が等しければfalse

自作のビルトイン
----------------------------------------

* list(?x,:a,:b,:c,…)
  - リストを生成して?xに代入
* cons(?x, ?y, ?z)
  - ?xを?yのリストの先頭要素に加えて?zに代入
    (list_appendと異なり?yのリストはコピーされない)
* list2string(?x, ?y)
  - ?xのリストの要素を文字列に変換して連結したものを?yに代入
* list_append(?x, ?y, ?z)
  - リスト?xとリスト?yを結合して?zに代入．
    (?zのリストのインスタンスは新規に作られる．)
* print_list(?x)
  - リスト?xを標準出力に表示．

前向き推論
----------------------------------------

### 空リストの生成

    rdf:nil

### carの例

    (?x rdf:first ?y)

### cdrの例

    (?x rdf:rest ?y)

### consの例

ルール

    @prefix : <http://test.org/> .
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    (?a :cons1 ?x), (?a :cons2 ?y), makeTemp(?z) ->
        (?z rdf:first ?x), (?z rdf:rest ?y) .

N3

    @prefix : <http://test.org/> .
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    [ :cons1 '0';
      :cons2 ('1' '2' '3') ] .

結果

    @prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix :        <http://test.org/> .
    []    :cons1  "0" ;
          :cons2  _:b1 .
    ("0" "1" "2" "3") .

後ろ向き推論
----------------------------------------

@prefix : <http://test.org/> .
(:car :result ?res) <- (:car :input ?x), (?x rdf:first ?res) .

????????????????????????
