title: tutorial1

JenaCheckの基本
========================================

インストール
----------------------------------------

JavaWebStartで公開しています．
基本的にクリックしていくだけでインストールできます．

* <http://ks1.org/nz/webstart/JenaCheck/>

セマンティックウェブの基礎
----------------------------------------

JenaCheckは，標準技術を使うので，資料はいろいろな
ところからゲットできます．

* [Wikipedia:Semantic Web] [wp:semweb]
* [Wikipedia:RDF] [wp:rdf]
* [Wikipedia:OWL] [wp:owl]
* [W3C:N3によるRDFとセマンティックWeb入門] [w3c:n3]
* [KanzakiWeb:Notaion3] [kw:n3]
* [IBM:SPARQLでRDFデータを検索する] [ibm:sparql]
* [人工知能I:プロダクションシステム] [ai1:ps]
* [Jenaのルールの文法] [jena:rule]
* [KanzakiWeb:Semantic Web] [kw:semweb]
* [W3C:RDF] [w3c:rdf]

[wp:semweb]: http://ja.wikipedia.org/wiki/Semantic_Web
[wp:rdf]: http://ja.wikipedia.org/wiki/Resource_Description_Framework
[wp:owl]: http://ja.wikipedia.org/wiki/OWL
[w3c:n3]: http://www.w3.org/2003/02/Primer.ja.html
[kw:n3]: http://www.kanzaki.com/docs/sw/n3.html
[ibm:sparql]: http://www-06.ibm.com/jp/developerworks/java/050616/j_j-sparql.html
[ai1:ps]: http://www.hiu.ac/ai/zenki/11/ppt/index.html
[jena:rule]: http://jena.sourceforge.net/inference/index.html#RULEsyntax
[kw:semweb]: http://www.kanzaki.com/docs/sw/
[w3c:rdf]: http://www.w3.org/RDF/

三つ組について
----------------------------------------

### 三つ組とは…

セマンティックウェブ(というかRDF)では三つ組というものを用いて
あらゆる情報を表現します．これは「主語」，「述語」，「目的語」
の三つの組のことです．以下Jenaのルール，Notation3，SPARQLを
説明していきますが，全てこの概念が使われています．

詳しくは以下のページを参照して下さい．

* <http://ja.wikipedia.org/wiki/Resource_Description_Framework>
* <http://ja.wikipedia.org/wiki/Semantic_Web>
* <http://ja.wikipedia.org/wiki/OWL>

### 項

上の三つ組の主語，述語，目的語の部分にはURI，リテラル，
変数のどれかを書きますが，基本はURIです．URIの例は，

    <https://ks1.org/semweb/#test>
    <http://www.do-johodai.ac.jp/semweb/#テスト>

のようなもので，多くはホームページのアドレスを大なり記号`<`と
小なり記号`>`で囲んだものになります．目的語の部分には特別にリテラル
というものが書けます．リテラルの例は

    'テストの文字'
    20060921
    3.14

のようなものになります．基本的に文字や数字などで文字列の場合は
シングルクォーテーションで囲みます．(リテラルの型を指定する方法
もありますが省略します．)それともう一つ，変数も使えます．変数の例は，

    ?x
    ?y
    ?var1

などです．最初にクエスチョンマークを付けます．
これらを利用すると以下のような三つ組が作れることになります．

    <http://www.do-johodai.ac.jp/> <http://purl.org/dc/elements/1.1/title> '北海道情報大学'

これは，`<http://www.do-johodai.ac.jp/>`のタイトルは`'北海道情報大学'`
であるということを意味します．`<http://purl.org/dc/elements/1.1/title>`はタイトル
という述語の意味を持つURIです．変数を使うと，

    ?x <http://purl.org/dc/elements/1.1/title> ?y

のような三つ組が作れて，何かタイトルを持っているもの全てに対応する三つ組
となります．

### プレフィックス

URIの形式は長くなってしまうので，プレフィックスというものが
使えるようになっています．プレフィックスを使う場合は，最初に
それを宣言する必要があります．以下はNotation3の例です．

    @prefix hiu: <http://www.do-johodai.ac.jp/semweb/#> .
    hiu:a hiu:b hiu:c .

上は以下と同じ意味です．

    <http://www.do-johodai.ac.jp/semweb/#a>
        <http://www.do-johodai.ac.jp/semweb/#b>
        <http://www.do-johodai.ac.jp/semweb/#c> .

プレフィックスを使うと`<…>`の小なり記号と大なり記号も省略
されるので気をつけましょう．

Jenaのルールの文法
----------------------------------------

JenaというのはセマンティックウェブのためのJavaで書かれた
プログラムで，JenaCheckではこれを利用しています．

Jenaのルールは2種類あります．1つは前向き推論のためのルールで，
もう一つは後向き推論のためのルールです．

とりあえず，前向き推論のためのルールを説明します．
基本的にJenaのルールの文法は三つ組がベースになっていて，

    (主語 述語 目的語), (主語 述語 目的語)… -> (主語 述語 目的語)… .

のようになっています．`(主語 述語 目的語)`の部分が三つ組で，三つ組は
まる括弧で囲むことになっています．途中に`->`という記号が入っており，
ルールの最後にはピリオドを付けることになっています．
`->`の左が条件部(別名:tail)で右が実行部(別名:head)と呼ばれます．
三つ組のかわりに特殊な形として`print('test')`のようなビルトインと
呼ばれるものを含めることもできます．条件部を省略すると無条件のルール
(つまり事実)を書くこともできます．

    -> (主語 述語 目的語)… .

そして，後ろ向き推論のためのルールは`->`の記号が`<-`と逆向き
になります．

    (主語 述語 目的語), (主語 述語 目的語)… <- (主語 述語 目的語)… .

これに従って左側が実行部，右側が条件となりますが，それ以外は
文法的にはあまり違いはありません(ちょっとある)．実行する時に
違いがでてきますが，それは後々説明します．

詳しくは以下のページを参照して下さい．

* <http://jena.sourceforge.net/inference/index.html#RULEsyntax>

Notation3
----------------------------------------

Jenaの三つ組の事実と同じものを表現するための方法で
こちらは，Jenaというソフトに固有の文法ではなく
ちゃんとした規格です(と言うかたぶんJenaがNotation3をまね
したのだと思う)．ですが基本的な部分はJenaのルール
と似ていて，さらに色々な形の省略形が使えるようになって
います．

例えば`<http://www.do-johodai.ac.jp>`のタイトルは`'北海道情報大学'`
である，という内容はNotation3では以下のように書けます．

    @prefix dc: <http://purl.org/dc/elements/1.1/> .
    <http://www.do-johodai.ac.jp> dc:title '北海道情報大学' .

Notation3では括弧はいりません．そして最後にピリオドが付くのは
Jenaのルールと同じです．プレフィックスの書き方もJenaのルールと
同じです．詳しくは以下のページを参照して下さい．

* <http://www.w3.org/2003/02/Primer.ja.html>
* <http://www.kanzaki.com/docs/sw/n3.html>

SPARQL
----------------------------------------

三つ組の情報をリレーショナルデータベースのSQL文の
ようなもので検索することができるようになっています．

    SELECT *
    WHERE { ?x ?y ?z }

このクエリを使えば，三つ組の全ての情報を表の形で表示します．
表示をNotation3形式にしたい場合は次のクエリが使えます．

    CONSTRUCT { ?x ?y ?z }
    WHERE { ?x ?y ?z }

SPARQLでも文法は微妙に違いますがプレフィックスが使えます．

    PREFIX dc: <http://purl.org/dc/elements/1.1/>
    SELECT ?x ?y
    WHERE {
        ?x dc:title ?y .
    }

詳しい内容は以下のページを参照して下さい．

* <http://www-06.ibm.com/jp/developerworks/java/050616/j_j-sparql.html>

ルールを実行する方法
----------------------------------------

ルールの実行は，前向き推論の場合ルールがセットされた時と
Notation3が新しく追加された時に行われます．後向き推論は
SPARQLで検索された時に行われます．

試しに以下の内容で，ルールのセットとNotation3の追加と
SPARQLの検索を，この順番で実行してみて下さい．

ルール：

    @prefix : <http://test.org/> .
    (?x :叔父 ?z) <- (?y :父 ?z), (?y :兄弟 ?x) .

Notation3:

    @prefix : <http://test.org/> .
    :情報一郎 :父   :情報二郎 .
    :情報一郎 :兄弟 :情報三郎 .

SPARQL:

    PREFIX : <http://test.org/>
    SELECT ?x
    WHERE {
        ?x :叔父 :情報二郎
    }

情報三郎が出てくるはずです．
これは後向き推論の例になってます．上のようにプレフィックスとして
文字列を何も指定しないで`:`だけというのも使えます．
実際のところ上の叔父のルールは足りないところがあります．
(母親の兄弟も叔父ですね．)さらに色々ルールとデータを加えて改良
してみて下さい．

Prologとの関係
----------------------------------------

Jenaのルールは，基本的な部分ではPrologのホーン節と同じ論理式による
ルールの表現ですが，表記法が異なっているため違うものに見えてしまい
ます．Prologでは，「一郎は二朗の父親である」は「父親(一郎,二朗)」と
表現しますが，Jenaのルールでは「(:一郎 :父親 :二朗)」のような形で
表現します．Prologで「シロは犬である」は「犬(シロ)」と書けますが，
Jenaのルールでは「(:シロ rdf:type :犬)」と表現します(セマンティック
ウェブ的に，より厳密にするにはもう少し工夫が必要)．
Prologでは引数の数が3個以上の述語も定義できますが，これはJenaでは
直接表記することはできません．ですが，複数の三つ組を組合せたり
(この文章では説明しませんでしたが)空白ノードを
使用するなどの工夫で対応することができます．

ちなみに，データベースの世界では，このように引数を1つか2つに限定した
The Unary/Binary Datalogというクエリが存在するようです．

それと，Prologでは「リスト」を扱うための洗練された表記法があり
ますが，Jenaでリストを扱うのは不可能ではないですが，現在は難しい
です．またPrologではバックトラックを制御するためのカット演算子
「!」がありますが，とりあえず今のところ使えません．
(ルールの中で一度だけ成功するビルトインを作れば良さそうでは
あるけど…)


SWRLとの関係
----------------------------------------

現在，セマンティックウェブの世界でルールを記述するための標準
的な規格としてSWRL(Semantic Web Rule Language)があり，
将来普及するものと思われます．ただ，この規格はまだ確定された
ものではないため，Jenaではまだ使えない状況ですが，しかしJenaの
ルールは基本的な部分ではSWRLとすなおに対応するものになっているので，
Jenaのルールで書いたルールはわりと楽にSWRLに移植できるようになる
と思います．(というか近い将来JenaがSWRLに対応してくれると思う
のですが…)

試しに…
----------

最近ブログなどではRSSと呼ばれる情報を配信する所が増えてきています．
ホームページの更新情報などが三つ組の形式で保存されたものです．
これを読み込んでいろいろ検索してみて下さい．メニューの「ファイル」
の「RDFをロード」で以下のURLを入力すると直接読み込めます．

* 朝日新聞のRSS<http://www3.asahi.com/rss/index.rdf>
