package jp.ac.do_johodai.j314.sw.jc;

import java.io.*;
import javax.swing.*;
import javax.swing.text.*;

public class JTextAreaOutputStream extends OutputStream {
    JTextArea textArea;
    PrintStream systemOut;
    byte queue[];
    int position = 0;

    public JTextAreaOutputStream(JTextArea ta, PrintStream systemOut) {
        this.systemOut = systemOut;
        textArea = ta;
        queue = new byte[256];
    }

    public void write(int b) {
        systemOut.write(b);
        queue[position++] = (byte) b;
        if (position >= 256)
            flush();
    }

    public void flush() {
        systemOut.flush();
        String s = new String(queue, 0, position);
        position = 0;
        textArea.append(s);
        Document d = textArea.getDocument();
        Position p = d.getEndPosition();
        Caret c = textArea.getCaret();
        c.setDot(p.getOffset());
    }
}
