package jp.ac.do_johodai.j314.sw.jc;

import java.awt.event.*;
import javax.swing.*;

/**
 * もともとJenaの推論機能の能力をチェックするために 作ったプログラムだが、
 * ちょっとしたエージェントとしての機能も付いている。いつもの癖で、
 * アプリケーションでも アプレットでも動作するようにプログラムしたのだが、
 * でかくなったのでアプレットで実行するのは非現実的。
 */
public class JenaCheck extends JApplet implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton startDemoButton;
    JApplet applet = null;
    JFrame frame;

    public void init() {
        applet = this;
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Click to execute JenaCheck!"), "North");
        startDemoButton = new JButton("Start");
        startDemoButton.addActionListener(this);
        box.add(startDemoButton);
        getContentPane().add(box);
    }

    public void makeFrame() {
        frame = new JenaFrame(this);
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                disposeThis();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == startDemoButton)
            makeFrame();
    }

    void disposeThis() {
        if (applet == null)
            System.exit(0);
        else
            frame.dispose();
    }

    public static void main(String[] args) {
        // セキュリティマネージャが、
        // LinuxのJava Web Startの時だけ
        // Exceptionを出すので、とりあえずnullに
        // しておく。
        System.setSecurityManager(null);
        final String argsCopy[] = args;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                JenaCheck jc = new JenaCheck();
                jc.makeFrame();
            }
        });
    }
}
