package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

/**
 * Acerola3Dのキャラクタに吹き出しを出して、
 * そこに文字を表示させるためのビルトイン。
 * ビルトインの名前は'a3print'。
 * 第1引数がAcerola3Dを特定するためのIDとなる
 * リソースで、第2引数が表示させたい文字列である。
 * 文字列として空文字列を指定すると吹き出しが
 * 消去される。
 */
public class A3PrintBuiltin extends BaseBuiltin {
    public String getName() {
        return "a3print";
    }

    public int getArgLength() {
        return 0;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length >= 2)
            return false;
        if (!A3NewBuiltin.hash.containsKey(args[0]))
            return false;
        return print(args);
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        print(args);
    }

    boolean print(Node args[]) {
        A3NewBuiltin.MyFrame f = A3NewBuiltin.hash.get(args[0]);
        String v = "";
        for (int i=1;i<args.length;i++) {
            v = v + ((Node_Literal) args[i]).getLiteralLexicalForm();
        }
        v.trim();
        if (v.equals(""))
            f.setBalloon(null);
        else
            f.setBalloon(v);
        return true;
    }
}
