package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * 第1引数(整数)を文字列に変換して第2引数(文字列)の変数に
 * 代入する。
 * ビルトインの名前は'int2string'。
 */
public class Int2StringBuiltin extends BaseBuiltin {
    public String getName() {
        return "int2string";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        int2string(args,length,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        int2string(args,length,context);
    }
    void int2string(Node[] args, int length, RuleContext context) {
        String s = ((Node_Literal)args[0]).getLiteralLexicalForm();
        Node n = Node.createLiteral(s);
        BindingEnvironment env = context.getEnv();
        env.bind(args[1],n);
    }
}
