package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

/**
 * 形態素解析をするための初期化処理を行うビルトイン。
 * ビルトインの名前は'keitaiso_init'。第1引数にsenの
 * インストールフォルタ名を文字列として与える。
 */
public class KeitaisoInitBuiltin extends BaseBuiltin {
    public String getName() {
        return "keitaiso_init";
    }

    public int getArgLength() {
        return 1;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 1)
            return false;
        doKeitaisoInit(args,length,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        doKeitaisoInit(args,length,context);
    }

    void doKeitaisoInit(Node[] args,int length,RuleContext context) {
        String sh = ((Node_Literal) args[0]).getLiteralLexicalForm();
        System.setProperty("sen.home",sh);
    }
}
