package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

/**
 * 第1引数の文字リテラルの最後に、第2引数の文字リテラルがあるときは、
 * falseで、そうでない時はtrue。
 * ビルトインの名前は'notEndsWith'。
 */
public class NotEndsWithBuiltin extends BaseBuiltin {
    public String getName() {
        return "notEndsWith";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        String s1 = ((Node_Literal) args[0]).getLiteralLexicalForm();
        String s2 = ((Node_Literal) args[1]).getLiteralLexicalForm();
        if (s1.endsWith(s2))
        	return false;
        else
        	return true;
    }
}
