package jp.ac.do_johodai.j314.sw.je;

import java.io.*;
import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * 標準入力から1行文字列を受け取るためのビルトイン。
 * ビルトインの名前は'read'。第1引数を変数にしておくと、
 * その変数に文字列が代入される。
 */
public class ReadBuiltin extends BaseBuiltin {
    public String getName() {
        return "read";
    }

    public int getArgLength() {
        return 1;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        try {
            if (length != 1)
                return false;
            BufferedReader br = new BufferedReader(new InputStreamReader(
                    System.in));
            String s = br.readLine();
            Node n = Node.createLiteral(s);
            BindingEnvironment env = context.getEnv();
            env.bind(args[0], n);
            return true;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(
                    System.in));
            String s = br.readLine();
            Node n = Node.createLiteral(s);
            BindingEnvironment env = context.getEnv();
            env.bind(args[0], n);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
