package jp.ac.do_johodai.j314.sw.je;

import java.io.StringWriter;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;

import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

/**
 * RDFをNotation3に変換して他のエージェントに
 * おくるビルトイン。 ビルトインの名前は'send_n3'。
 * 第一引数がEndPointで、第2,3,4引数がS,P,O。
 * あと必要なだけ第5,6,7とかがあればS,P,O二組め。
 */
public class SendN3Builtin extends BaseBuiltin {
    public String getName() {
        return "send_n3";
    }

    public int getArgLength() {
        return 0;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length < 4)
            return false;
        if (((length - 1) % 3) != 0)
            return false;
        return callService(args);
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        callService(args);
    }

    boolean callService(Node[] args) {
        try {
            Model model = ModelFactory.createDefaultModel();
            int c = 1;
            while (args.length > c) {
                //RDFNode r = model.createResource(args[c].getURI());
                RDFNode r = model.getRDFNode(args[c + 0]);
                RDFNode p = model.createProperty(args[c + 1].getURI());
                //RDFNode p = model.getRDFNode(args[c + 1]);
                RDFNode o = model.getRDFNode(args[c + 2]);
                model.add((Resource)r, (Property)p, o);
                c = c + 3;
            }
//model.write(System.out,"N3");
            StringWriter sw = new StringWriter();
            model.write(sw, "N3");
            String epr = ((Node_Literal) args[0]).getLiteralLexicalForm();
            epr.trim();
            EndpointReference targetEPR = new EndpointReference(epr);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(
                    "http://x314.do-johodai.ac.jp/sw_ws/xsd", "example1");
            OMElement method = fac.createOMElement("n3_insert", omNs);
            OMElement value = fac.createOMElement("Text", omNs);
            value.addChild(fac.createOMText(value, sw.toString()));
            method.addChild(value);
            Options options = new Options();
            options.setTo(targetEPR);
            ServiceClient serviceClient = new ServiceClient();
            serviceClient.setOptions(options);
            //OMElement result = serviceClient.sendReceive(method);
            serviceClient.sendReceive(method);
            // serviceClient.fireAndForget(method);
            return true;
        } catch (AxisFault af) {
            af.printStackTrace();
            return false;
        }

    }
}
