package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * 第1引数の表すURI(変数名のかわりに使う)で保存されている内容を、
 * 第2引数の変数に代入する。
 * ビルトインの名前は'state_get'。
 * 状態を保存しておくための特別の変数領域を確保するビルトイン。
 * 論理学的には禁断のビルトインになるかもしれない。
 * 
 * 第1引数は、代入された変数を指定しても良い。でも、たぶん、
 * bindビルトインやlistEntryビルトインなどで代入された変数では
 * だめで、ルールの条件部で当てはめられた変数でないとだめっぽい。
 * それと、第二引数の変数もbindと同じ方法で代入しているので、
 * state_getにより代入された変数も危険。
 * このへんはJenaの実装依存みたいで、ちょっと気持わるい。
 */
public class StateGetBuiltin extends BaseBuiltin {

    public String getName() {
        return "state_get";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        state_get(args,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        if (length != 2) {
        	System.out.println("StateSetBuiltin: ???");
            return;
        }
        state_get(args,context);
    }
    void state_get(Node[] args,RuleContext context) {
    	if (args[0] instanceof Node_Fluid) {
    		System.out.println("StateSetBuiltin: WARNING : variable???");
    	}
        Node n = StateSetBuiltin.map.get(args[0]);
        BindingEnvironment env = context.getEnv();
        env.bind(args[1],n);
    }
}
