package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import java.util.*;

/**
 * 第1引数の表すURI(変数名のかわりに使う)に、第2引数の内容を設定する。
 * ビルトインの名前は'state_set'。
 * 状態を保存しておくための特別の変数領域を確保するビルトイン。
 * 論理学的には禁断のビルトインになるかもしれない。
 * 
 * 第1、第2引数とも、代入された変数を指定しても良い。でも、たぶん、
 * bindビルトインやlistEntryビルトインなどで代入された変数では
 * だめで、ルールの条件部で当てはめられた変数でないとだめっぽい。
 * このへんはJenaの実装依存みたいで、ちょっと気持わるい。
 */
public class StateSetBuiltin extends BaseBuiltin {
	static HashMap<Node,Node> map = new HashMap<Node,Node>();

    public String getName() {
        return "state_set";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        state_set(args);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        if (length != 2) {
        	System.out.println("StateSetBuiltin: ???");
            return;
        }
        state_set(args);
    }
    void state_set(Node[] args) {
    	if ((args[0] instanceof Node_Fluid)||(args[1] instanceof Node_Fluid)) {
    		System.out.println("StateSetBuiltin: WARNING : variable???");
    	}
        map.put(args[0],args[1]);
        //System.out.println("args[0]:"+args[0].getClass().getName());
        //System.out.println("args[1]:"+args[1].getClass().getName());
    }
}
