package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * 第1引数(文字列)を整数に変換して第2引数(整数)の変数に
 * 代入する。
 * ビルトインの名前は'string2int'。
 */
public class String2IntBuiltin extends BaseBuiltin {
    public String getName() {
        return "string2int";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        string2int(args,length,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        string2int(args,length,context);
    }
    void string2int(Node[] args, int length, RuleContext context) {
        String s = ((Node_Literal)args[0]).getLiteralLexicalForm();
        long l = Long.parseLong(s);
        Node n = Node.create(""+l);
        BindingEnvironment env = context.getEnv();
        env.bind(args[1],n);
    }
}
