package jp.sourceforge.sxdbutils.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/**
 * 定数アノテーションにより、カラム名が指定できる {@link NameMapping}です。
 * 
 * @author chinpei
 * 
 */
public class ConstantAnnoNameMapping implements NameMapping {
	private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();

	private static final String ANNOTATION_SUFFIC = "_COLUMN";
	private final OverwriteNameMapping delegateNameMapping;

	public ConstantAnnoNameMapping(Class beanClass) {
		this(beanClass, DEFAULT_COMVERSION);
	}

	public ConstantAnnoNameMapping(Class beanClass,
			NameMapping defaultNameMapping) {
		Map columnToPropertyMap = new HashMap();
		Field[] fields = beanClass.getDeclaredFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			if (isColumnAnnotation(field)) {
				String propertyName = ReflectionUtil.removalSuffixFieldName(
						field, ANNOTATION_SUFFIC);
				String columnName = ReflectionUtil.getString(field);
				columnToPropertyMap.put(propertyName, columnName);
			}
		}
		this.delegateNameMapping = new OverwriteNameMapping(columnToPropertyMap,
				defaultNameMapping);
	}

	public String toIntermediateName(PropertyDescriptor propertyDescriptor) {
		return this.delegateNameMapping.toIntermediateName(propertyDescriptor);
	}

	public final Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateName(String columnName) {
		return this.delegateNameMapping.toIntermediateName(columnName);
	}
	
	public String toColumnName(PropertyDescriptor propertyDescriptor) {
		return this.delegateNameMapping.toColumnName(propertyDescriptor);
	}

	/**
	 * カラムアノテーションの判定
	 * 
	 * @param field
	 * @return
	 */
	public static boolean isColumnAnnotation(Field field) {
		if (!ReflectionUtil.isPublicStaticFinalString(field)) {
			return false;
		}
		if (field.getName().endsWith(ANNOTATION_SUFFIC)) {
			return true;
		}
		return false;
	}
}
