package jp.sourceforge.sxdbutils.util;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;

public class SqlDateUtils {
	private SqlDateUtils(){}
	public static Time toSqlTime(Date date) {
		if (date == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.YEAR, 1970);
		cal.set(Calendar.MONTH, Calendar.JANUARY);
		cal.set(Calendar.DATE, 1);
		return new java.sql.Time(cal.getTimeInMillis());
	}

	public static java.sql.Date toSqlDate(Date date) {
		if (date == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return new java.sql.Date(cal.getTimeInMillis());
	}
}
