/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.bean.ColumnNameMapping;
import jp.sourceforge.sxdbutils.bean.NameMapping;
import jp.sourceforge.sxdbutils.bean.OverwriteNameMapping;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

public class ConstantAnnoNameMapping
implements NameMapping {
    private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();
    private static final String ANNOTATION_SUFFIC = "_COLUMN";
    private final OverwriteNameMapping delegateNameMapping;

    public ConstantAnnoNameMapping(Class beanClass) {
        this(beanClass, DEFAULT_COMVERSION);
    }

    public ConstantAnnoNameMapping(Class beanClass, NameMapping defaultNameMapping) {
        HashMap<String, String> columnToPropertyMap = new HashMap<String, String>();
        Field[] fields = beanClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!ConstantAnnoNameMapping.isColumnAnnotation(field)) continue;
            String propertyName = ReflectionUtil.removalSuffixFieldName(field, ANNOTATION_SUFFIC);
            String columnName = ReflectionUtil.getString(field);
            columnToPropertyMap.put(propertyName, columnName);
        }
        this.delegateNameMapping = new OverwriteNameMapping(columnToPropertyMap, defaultNameMapping);
    }

    public String toIntermediateName(PropertyDescriptor propertyDescriptor) {
        return this.delegateNameMapping.toIntermediateName(propertyDescriptor);
    }

    public final Map createIntermediateMap() {
        return new CaseInsensitiveHashMap();
    }

    public String toIntermediateName(String columnName) {
        return this.delegateNameMapping.toIntermediateName(columnName);
    }

    public String toColumnName(PropertyDescriptor propertyDescriptor) {
        return this.delegateNameMapping.toColumnName(propertyDescriptor);
    }

    public static boolean isColumnAnnotation(Field field) {
        if (!ReflectionUtil.isPublicStaticFinalString(field)) {
            return false;
        }
        return field.getName().endsWith(ANNOTATION_SUFFIC);
    }
}

