package jp.sourceforge.sxdbutils.bean;

import java.beans.PropertyDescriptor;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.NameConvertUtils;

/**
 * 中間マッピング名にカラム名を使用する {@link NameMapping}の実装です。
 * プロパティは、逆キャメル変換によってカラム名に変換されます。
 * 
 * @author chinpei
 * 
 */
public class CamelNameMapping implements NameMapping {

	public String toIntermediateName(PropertyDescriptor propertyDescriptor) {
		return NameConvertUtils.camelToColumnName(propertyDescriptor.getName());
	}

	public Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateName(String columnName) {
		return columnName;
	}
	public String toColumnName(PropertyDescriptor propertyDescriptor) {
		return NameConvertUtils.camelToColumnName(propertyDescriptor.getName());
	}
}
