package jp.sourceforge.sxdbutils.util;


public class DatabaseColumnInfo {
	/**
	 * 列名
	 */
	public static final int COLUMN_NAME_INDEX = 4;
	/**
	 * java.sql.Types からの SQL の型
	 */
	public static final int DATA_TYPE_INDEX = 5;
	/**
	 * データソース依存の型名。UDT の場合、型名は完全指定
	 */
	public static final int TYPE_NAME_INDEX = 6;
	/**
	 * 列サイズ
	 */
	public static final int COLUMN_SIZE_INDEX = 7;
	/**
	 * 小数点以下の桁数。DECIMAL_DIGITS が適用できないデータ型の場合は、Null が返される。
	 */
	public static final int DECIMAL_DIGITS_INDEX = 9;

	private String columnName;
	private int dataType;
	private String typeName;
	private int columnSize;
	private int decimalDigits;

	public String toString() {
		StringBuffer builder = new StringBuffer(256);

		builder.append(OthersUtils.rightPad(columnName, 25));
		builder.append(OthersUtils.rightPad(typeName, 15) + "("
				+ OthersUtils.leftPad(dataType + "", 5) + ")");
		builder.append(OthersUtils.leftPad(columnSize + "", 15) + "("
				+ decimalDigits + ")");
		return builder.toString();
	}

	public String getColumnName() {
		return columnName;
	}

	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}

	public int getDataType() {
		return dataType;
	}

	public void setDataType(int dataType) {
		this.dataType = dataType;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public int getColumnSize() {
		return columnSize;
	}

	public void setColumnSize(int columnSize) {
		this.columnSize = columnSize;
	}

	public int getDecimalDigits() {
		return decimalDigits;
	}

	public void setDecimalDigits(int decimalDigits) {
		this.decimalDigits = decimalDigits;
	}

}
