package jp.sourceforge.sxdbutils.bean;

import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.util.QueryUtil;

public class VersionColumnProperty implements BeanColumn {

	private final BeanColumn delegate;

	public VersionColumnProperty(BeanColumn delegate) {
		this.delegate = delegate;
	}

	public String getColumnName() {
		return delegate.getColumnName();
	}

	public ValueType getValueType() {
		return delegate.getValueType();
	}

	public Object read(Object bean) {
		return QueryUtil.getNextVersion(delegate.read(bean));
	}
}
