package jp.sourceforge.sxdbutils.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.PersistenceEntry;
import jp.sourceforge.sxdbutils.meta.VersionColumnPersistenceEntry;
import jp.sourceforge.sxdbutils.util.OthersUtils;

/**
 * AttributeQueryFactoryのビルダーです。
 * 
 * @author chinpei
 * 
 */
public abstract class AttributeQueryFactoryBuilder {

	private static final NameMapping DEFAULT_NAME_MAPPING = new ColumnNameMapping();

	protected String tableName;
	protected final Class baseClass;
	protected final NameMapping nameMapping;
	protected Set whereKeyColumnSet;
	protected String versionColumnName;

	/**
	 * KEY：カラム名、VALUE：SQLタイプ
	 */
	protected Map columnTypeMap = new HashMap();

	// List<String>
	protected Set excludeColumns = new HashSet();

	public AttributeQueryFactoryBuilder(Class baseClass) {
		this(baseClass, DEFAULT_NAME_MAPPING);
	}

	public AttributeQueryFactoryBuilder(Class baseClass, NameMapping nameMapping) {
		this.baseClass = baseClass;
		this.nameMapping = nameMapping;
		this.tableName = OthersUtils.getShortClassName(baseClass);
	}


	private boolean isWhereKey(String columnName) {
		if (this.whereKeyColumnSet == null)
			return false;
		return this.whereKeyColumnSet.contains(columnName.toLowerCase());
	}

	public QueryFactory buildUpdate() {
		PersistenceEntry[] beanColumns = this.toPersistenceEntries();

		StringBuffer columnBuffer = new StringBuffer(beanColumns.length * 7);

		List updateColumnProperties = new ArrayList();
		List whereColumnProperties = new ArrayList();

		columnBuffer.append("update ").append(this.tableName).append(" set ");
		boolean flg = false;
		for (int i = 0; i < beanColumns.length; i++) {

			PersistenceEntry beanColumn = beanColumns[i];
			if (isWhereKey(beanColumn.getColumnName())) {
				whereColumnProperties.add(beanColumn);
				continue;
			}
			if (flg) {
				columnBuffer.append(',');
			} else {
				flg = true;
			}
			columnBuffer.append(beanColumn.getColumnName()).append("=?");
			if (versionColumnName != null
					&& versionColumnName.equalsIgnoreCase(beanColumn
							.getColumnName())) {
				whereColumnProperties.add(beanColumn);
				updateColumnProperties.add(new VersionColumnPersistenceEntry(
						beanColumn));
			} else {
				updateColumnProperties.add(beanColumn);
			}
		}
		StringBuffer whereBuffer = null;
		if (!whereColumnProperties.isEmpty()) {
			for (Iterator iterator = whereColumnProperties.iterator(); iterator
					.hasNext();) {
				if (whereBuffer == null)
					whereBuffer = new StringBuffer(" where ");
				else
					whereBuffer.append(" and ");
				PersistenceEntry columnProperty = (PersistenceEntry) iterator
						.next();
				whereBuffer.append(columnProperty.getColumnName()).append("=?");
			}
		}

		List list = new ArrayList(updateColumnProperties);
		list.addAll(whereColumnProperties);
		if (whereBuffer != null)
			columnBuffer.append(whereBuffer);
		String sql = columnBuffer.toString();
		return new AttributeQueryFactory(sql, (PersistenceEntry[]) list
				.toArray(new PersistenceEntry[list.size()]));
	}

	public QueryFactory buildInsert() {
		PersistenceEntry[] entries = this.toPersistenceEntries();
		StringBuffer columnBuffer = new StringBuffer(entries.length * 7);
		StringBuffer valueBuffer = new StringBuffer(entries.length * 2);

		columnBuffer.append("insert into ").append(this.tableName).append("(");
		valueBuffer.append(" values ( ");
		boolean flg = false;
		for (int i = 0; i < entries.length; i++) {

			if (flg) {
				columnBuffer.append(',');
				valueBuffer.append(',');
			} else {
				flg = true;
			}
			PersistenceEntry columnProperty = entries[i];
			columnBuffer.append(columnProperty.getColumnName());
			valueBuffer.append('?');
		}
		columnBuffer.append(" ) ");
		valueBuffer.append(" ) ");
		String sql = columnBuffer.append(valueBuffer).toString();

		return new AttributeQueryFactory(sql, entries);

	}

	public QueryFactory buildDelete() {
		PersistenceEntry[] entries = this.toPersistenceEntries();

		StringBuffer deleteBuffer = new StringBuffer(entries.length * 7);

		List whereEntries = new ArrayList();

		deleteBuffer.append("delete from ").append(this.tableName);
		for (int i = 0; i < entries.length; i++) {

			PersistenceEntry entry = entries[i];
			if (isWhereKey(entry.getColumnName())) {
				whereEntries.add(entry);
				continue;
			}
			if (versionColumnName != null
					&& versionColumnName
							.equalsIgnoreCase(entry.getColumnName())) {
				whereEntries.add(entry);
			}
		}
		StringBuffer whereBuffer = null;
		if (!whereEntries.isEmpty()) {
			for (Iterator iterator = whereEntries.iterator(); iterator
					.hasNext();) {
				if (whereBuffer == null)
					whereBuffer = new StringBuffer(" where ");
				else
					whereBuffer.append(" and ");
				PersistenceEntry entry = (PersistenceEntry) iterator.next();
				whereBuffer.append(entry.getColumnName()).append("=?");
			}
		}

		if (whereBuffer != null)
			deleteBuffer.append(whereBuffer);
		String sql = deleteBuffer.toString();
		return new AttributeQueryFactory(sql, (PersistenceEntry[]) whereEntries
				.toArray(new PersistenceEntry[whereEntries.size()]));
	}


	protected abstract PersistenceEntry[] toPersistenceEntries();
	protected ValueType getValueType(AttributeDescpriotr attributeDescpriotr,
			Integer sqlType) {
		return sqlType == null ? TypeMappings.getValueType(attributeDescpriotr
				.getType()) : TypeMappings.getValueType(attributeDescpriotr
				.getType(), sqlType.intValue());
	}

}
