package jp.sourceforge.sxdbutils.tiger.processors;

import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;
import jp.sourceforge.sxdbutils.tiger.util.Util;

/**
 * public fieldにマッピングする {@link SxRowProcessor}。 カラム名とプロパティ名の名前が、 {@link NameMapping}
 * によって一致したものがマッピングされます。 デフォルトでは、カラム名でマッピングされます。
 * 
 * @author chinpei
 * 
 */
public class FieldRowProcessor<S>
		extends
		SxRowProcessorDelegate<S, jp.sourceforge.sxdbutils.processors.FieldRowProcessor> {

	public FieldRowProcessor(Class<S> beanClass) {
		super(new jp.sourceforge.sxdbutils.processors.FieldRowProcessor(
				beanClass));
	}

	public FieldRowProcessor(Class<S> beanClass, NameMapping nameMapping) {
		super(new jp.sourceforge.sxdbutils.processors.FieldRowProcessor(
				beanClass, nameMapping));
	}

	public Class<S> getBaseClass(){
		Class<S> result= Util.cast(this.delegate.getBaseClass());
		return result;
	}

}
