package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.sxdbutils.rstable.BasicResultColumnRepository;
import jp.sourceforge.sxdbutils.rstable.BasicResultRow;
import jp.sourceforge.sxdbutils.rstable.BasicResultTable;
import jp.sourceforge.sxdbutils.rstable.BinaryColumn;
import jp.sourceforge.sxdbutils.rstable.BooleanColumn;
import jp.sourceforge.sxdbutils.rstable.ClobToStringColumn;
import jp.sourceforge.sxdbutils.rstable.NumericColumn;
import jp.sourceforge.sxdbutils.rstable.ObjectColumn;
import jp.sourceforge.sxdbutils.rstable.ResultColumn;
import jp.sourceforge.sxdbutils.rstable.BasicResultColumnMetaData;
import jp.sourceforge.sxdbutils.rstable.ResultColumnRepository;
import jp.sourceforge.sxdbutils.rstable.ResultRow;
import jp.sourceforge.sxdbutils.rstable.SqlDateColumn;
import jp.sourceforge.sxdbutils.rstable.StringColumn;
import jp.sourceforge.sxdbutils.rstable.TimeColumn;
import jp.sourceforge.sxdbutils.rstable.TimestampColumn;

import org.apache.commons.dbutils.ResultSetHandler;

public class ResultTableHandler implements ResultSetHandler/*<ResultTable>*/{
	public Object handle(ResultSet rs) throws SQLException {
		ResultSetMetaData meta = rs.getMetaData();
		ResultColumn[] resultColumns = createResultColumns(meta);
		ResultColumnRepository repo = new BasicResultColumnRepository(resultColumns);
		return new BasicResultTable(repo, createResultRows(rs, repo));
	}

	protected List/*<ResultRow>*/createResultRows(ResultSet rs, ResultColumnRepository repo) throws SQLException {
		List/*<ResultRow>*/result = new ArrayList/*<ResultRow>*/();
		while (rs.next()) {
			result.add(createResultRow(rs, repo));
		}
		return result;
	}

	protected ResultRow createResultRow(ResultSet rs, ResultColumnRepository repo) throws SQLException {
		Object[] rowValues = new Object[repo.size()];
		for (int i = 0; i < repo.size(); i++) {
			ResultColumn resultColumn = repo.getResultColumn(i);
			rowValues[i] = resultColumn.getValue(rs);
		}
		return new BasicResultRow(repo, rowValues);
	}

	protected ResultColumn[] createResultColumns(ResultSetMetaData meta) throws SQLException {
		ResultColumn[] result = new ResultColumn[meta.getColumnCount()];
		for (int i = 0; i < meta.getColumnCount(); i++) {
			result[i] = createResultColumn(meta, i);
		}
		return result;
	}

	protected ResultColumn createResultColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		switch (meta.getColumnType(columnIndex + 1)) {
		case Types.CHAR:
		case Types.VARCHAR:
		case Types.LONGVARCHAR:
		case -15: //Types.NCHAR:
		case -9: //Types.NVARCHAR:
			return createStringTypeColumn(meta, columnIndex);
		case Types.BIGINT:
		case Types.DECIMAL:
		case Types.DOUBLE:
		case Types.FLOAT:
		case Types.INTEGER:
		case Types.NUMERIC:
		case Types.REAL:
		case Types.SMALLINT:
		case Types.TINYINT:
			return createNumericTypeColumn(meta, columnIndex);
		case Types.DATE:
			return createDateTypeColumn(meta, columnIndex);
		case Types.TIMESTAMP:
			return createTimestampTypeColumn(meta, columnIndex);
		case Types.TIME:
			return createTimeTypeColumn(meta, columnIndex);
		case Types.CLOB:
			return createClobTypeColumn(meta, columnIndex);
		case Types.BLOB:
		case Types.BINARY:
		case Types.VARBINARY:
			return createBinaryTypeColumn(meta, columnIndex);
		case Types.BOOLEAN:
			return createBooleanTypeColumn(meta, columnIndex);
		default:
			return createOthersTypeColumn(meta, columnIndex);
		}
	}

	protected ResultColumn createStringTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new StringColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

	protected ResultColumn createClobTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new ClobToStringColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

	protected ResultColumn createNumericTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new NumericColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

	protected ResultColumn createDateTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new SqlDateColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

	protected ResultColumn createTimestampTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new TimestampColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

	protected ResultColumn createTimeTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new TimeColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

	protected ResultColumn createBinaryTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new BinaryColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

	protected ResultColumn createBooleanTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new BooleanColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

	protected ResultColumn createOthersTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
		return new ObjectColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
	}

}
