package jp.sourceforge.sxdbutils.meta;

import java.lang.reflect.Field;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.ReflectionUtil;

public class FieldAttributeDescpriotr implements AttributeDescpriotr {

	public static void putDescriptorToMap(Class clazz, Map descriptorMap) {
		Field[] fields = clazz.getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			descriptorMap.put(field.getName(), new FieldAttributeDescpriotr(
					field));
		}
	}

	private final Field field;
	private final String name;
	private final Class type;

	public FieldAttributeDescpriotr(Field field) {
		this.field = field;
		this.name = field.getName();
		this.type = field.getType();
	}

	public Object read(Object object) {

		return ReflectionUtil.getObject(object,field);
	}

	public void write(Object object, Object attrValue) {
		ReflectionUtil.setObject(field, object, attrValue);
	}

	public String getName() {
		return name;
	}

	public Class getType() {
		return this.type;
	}

	public boolean isReadable() {
		return true;
	}

	public boolean isWriteable() {
		return true;
	}

}
