package jp.sourceforge.sxdbutils.rstable;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class BooleanColumn extends AbstractColumn/*<Boolean>*/{
	static final BigDecimal ZERO = new BigDecimal("0");
	static final BigDecimal ONE = new BigDecimal("1");

	public BooleanColumn(int columnIndex, ResultColumnMetaData columnMeta) {
		super(columnIndex, columnMeta);
	}

	public Object valueOf(ResultSet rset) throws SQLException {
		Object object = rset.getObject(columnIndex + 1);
		if (object == null) {
			return null;
		}
		return Boolean.valueOf(rset.getBoolean(columnIndex + 1));
	}

	public BigDecimal getBigDecimal(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? ONE : ZERO;
	}

	public boolean getBoolean(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return false;
		return ((Boolean) value).booleanValue();
	}

	public Boolean getBooleanObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return (Boolean) value;
	}

	public byte getByte(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return (byte) 0;
		return ((Boolean) value).booleanValue() ? (byte) 1 : (byte) 0;
	}

	public Byte getByteObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Byte(((Boolean) value).booleanValue() ? (byte) 1 : (byte) 0);
	}

	public byte[] getBytes(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new byte[0];

	}

	public char getChar(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return '\u0000';
		return ((Boolean) value).booleanValue() ? '1' : '0';
	}

	public Character getCharacter(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Character(((Boolean) value).booleanValue() ? '1' : '0');
	}

	public Date getDate(Object[] rowdata) {
		return null;
	}

	public double getDouble(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0d;
		return ((Boolean) value).booleanValue() ? 1d : 0d;
	}

	public Double getDoubleObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Double(((Boolean) value).booleanValue() ? 1d : 0d);
	}

	public float getFloat(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0f;
		return ((Boolean) value).booleanValue() ? 1f : 0f;
	}

	public Float getFloatObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Float(((Boolean) value).booleanValue() ? 1f : 0f);
	}

	public int getInt(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0;
		return ((Boolean) value).booleanValue() ? 1 : 0;
	}

	public Integer getInteger(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Integer(((Boolean) value).booleanValue() ? 1 : 0);
	}

	public long getLong(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0L;
		return ((Boolean) value).booleanValue() ? 1L : 0L;
	}

	public Long getLongObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Long(((Boolean) value).booleanValue() ? 1L : 0L);
	}

	public short getShort(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return (short) 0;
		return ((Boolean) value).booleanValue() ? (short) 1 : (short) 0;
	}

	public Short getShortObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Short(((Boolean) value).booleanValue() ? (short) 1 : (short) 0);
	}

	public java.sql.Date getSqlDate(Object[] rowdata) {
		return null;
	}

	public String getString(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return value.toString();
	}

	public Time getTime(Object[] rowdata) {
		return null;
	}

	public Timestamp getTimestamp(Object[] rowdata) {
		return null;
	}

}
