package jp.sourceforge.sxdbutils.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class QueryUtil {
	private QueryUtil() {
	}

	private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal("1");
	public static boolean isBlank(CharSequence chars) {
		int len;
		if (chars == null || (len = chars.length()) == 0) {
			return true;
		}
		for (int i = 0; i < len; i++) {
			if ((Character.isWhitespace(chars.charAt(i)) == false)) {
				return false;
			}
		}
		return true;
	}

	public static boolean isEmpty(CharSequence chars) {
		if (chars == null)
			return true;
		return chars.length() == 0;
	}

	/**
	 * 指定されたインデックスから、指定文字列を置き換えて、次のインデックスを返す。 置き換えた次の位置を返す。
	 * 
	 * @param builder
	 * @param from
	 * @param to
	 * @return
	 */
	public static int replace(StringBuffer builder, String from, String to) {
		return replace(builder, from, to, 0);
	}

	/**
	 * 指定文字列を置き換えて、次の位置を返す。
	 * 
	 * @param builder
	 * @param from
	 * @param to
	 * @param fromIndex
	 * @return
	 */
	public static int replace(StringBuffer builder, String from, String to,
			int fromIndex) {
		int start = builder.indexOf(from, fromIndex);
		if (start == -1)
			return -1;
		int end = start + from.length();
		if (builder.length() < end)
			return -1;
		builder.replace(start, end, to);
		return start + to.length();
	}

	/**
	 * 指定された文字列を全て置き換えて、置き換えた個数を返す。
	 * 
	 * @param builder
	 * @param from
	 * @param to
	 * @return
	 */
	public static int replaceAll(StringBuffer builder, String from, String to) {
		int i = 0;
		int index = 0;
		while ((index = replace(builder, from, to, index)) != -1)
			i++;

		return i;
	}

	public static String sqlDateFormat(Date date) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(date);
	}

	public static String sqlDateFormat(Calendar cal) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(cal);
	}

	public static boolean appendLikeEscapeOracle(StringBuffer buffer,
			String text) {
		if (OthersUtils.isBlank(text))
			return false;
		boolean escape = false;
		for (int i = 0; i < text.length(); i++) {
			char c = text.charAt(i);
			switch (c) {
			case '%':
				buffer.append("\\%");
				escape = true;
				break;
			case '_':
				buffer.append("\\_");
				escape = true;
				break;
			case '\\':
				buffer.append("\\\\");
				escape = true;
				break;
			case '％':
				buffer.append("\\％");
				escape = true;
				break;
			case '＿':
				buffer.append("\\＿");
				escape = true;
				break;
			default:
				buffer.append(c);
				break;
			}
		}
		return escape;
	}

	/**
	 * Version番号をCOUNT UPさせる。
	 * 
	 * @param current
	 * @return
	 */
	public static Object getNextVersion(Object current) {

		if (current instanceof Integer) {
			Integer i = (Integer) current;
			return new Integer(i.intValue() + 1);
		}
		if (current instanceof Long) {
			Long l = (Long) current;
			return new Long(l.longValue() + 1L);
		}
		if (current instanceof BigDecimal) {
			BigDecimal bd = (BigDecimal) current;
			return bd.add(BIGDECIMAL_ONE);
		}
		if (current instanceof Date) {
			return new Date();
		}
		return null;
	}

}
