/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.BasicResultSetToObjectEntry;
import jp.sourceforge.sxdbutils.meta.PropertyAttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.ResultSetToObjectEntry;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

abstract class AttributeRowProcessor
implements SxRowProcessor {
    protected final Class baseClass;
    protected final NameMapping nameMapping;
    private static final NameMapping DEFAULT_NAME_MAPPING = new ColumnNameMapping();
    protected ResultSetToObjectEntry[] bindingEntries;

    public AttributeRowProcessor(Class baseClass) {
        this(baseClass, DEFAULT_NAME_MAPPING);
    }

    public AttributeRowProcessor(Class clazz, NameMapping nameMapping) {
        this.baseClass = clazz;
        this.nameMapping = nameMapping;
    }

    public void init(ResultSetMetaData rsmd) throws SQLException {
        HashMap attributeDescpriotrNameMap = new HashMap();
        this.putDescriptorToMap(this.baseClass, attributeDescpriotrNameMap);
        Map attributeDescpriotrMap = this.nameMapping.createIntermediateMap();
        Iterator iterator = attributeDescpriotrNameMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            attributeDescpriotrMap.put(this.nameMapping.toIntermediateNameFromAttrName((String)entry.getKey()), entry.getValue());
        }
        ArrayList<ResultSetToObjectEntry> list = new ArrayList<ResultSetToObjectEntry>();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            ResultSetToObjectEntry bindingEntry = this.getBindingEntry(rsmd, i + 1, attributeDescpriotrMap);
            if (bindingEntry == null) continue;
            list.add(bindingEntry);
        }
        this.bindingEntries = list.toArray(new ResultSetToObjectEntry[list.size()]);
    }

    public Object process(ResultSet rs) throws SQLException {
        Object bean = ReflectionUtil.newInstance(this.baseClass);
        ResultSetToObjectEntry bindingEntry = null;
        for (int i = 0; i < this.bindingEntries.length; ++i) {
            bindingEntry = this.bindingEntries[i];
            bindingEntry.set(bean, rs);
        }
        return bean;
    }

    protected abstract void putDescriptorToMap(Class var1, Map var2);

    protected ResultSetToObjectEntry getBindingEntry(ResultSetMetaData rsmd, int columnIndex, Map attributeDescpriotrMap) throws SQLException {
        String columnName = rsmd.getColumnLabel(columnIndex);
        AttributeDescpriotr attrDescpriotr = (AttributeDescpriotr)attributeDescpriotrMap.get(this.nameMapping.toIntermediateNameFromColumnName(columnName));
        if (attrDescpriotr == null) {
            return null;
        }
        if (!attrDescpriotr.isWriteable()) {
            return null;
        }
        int sqlType = rsmd.getColumnType(columnIndex);
        ValueType valueType = this.getValueType(attrDescpriotr, sqlType);
        if (valueType == null) {
            return null;
        }
        BasicResultSetToObjectEntry propertySetter = new BasicResultSetToObjectEntry(columnName, valueType, sqlType, columnIndex, attrDescpriotr);
        return propertySetter;
    }

    protected Map attributeDescpriotrNameMap() {
        HashMap attributeDescpriotrNameMap = new HashMap();
        PropertyAttributeDescpriotr.putDescriptorToMap(this.baseClass, attributeDescpriotrNameMap);
        return attributeDescpriotrNameMap;
    }

    protected ValueType getValueType(AttributeDescpriotr attrDescriptor, int sqlType) {
        return TypeMappings.getValueType(attrDescriptor.getType(), sqlType);
    }

    protected ValueType getValueType(Class type, int sqlType) {
        return TypeMappings.getValueType(type, sqlType);
    }

    public Class getBaseClass() {
        return this.baseClass;
    }
}

