<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LocationManager.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܴ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LocationManager.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_LocationManager
{
    /**
     * ̾
     * 
     * @access private
     * @var string
     */
    var $action_name = '';
    /**
     * ǥ쥯ȥ
     * 
     * @access private
     * @var string
     */
    var $action_dir = '';
    /**
     * ե
     * 
     * @access private
     * @var string
     */
    var $action_file = '';
    /**
     * 󥯥饹
     * 
     * @access private
     * @var string
     */
    var $action_class = '';
    /**
     * ƥץ졼ȥ
     * 
     * @access private
     * @var string
     */
    var $template_type = '';
    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access private
     * @var string
     */
    var $template_dir = '';
    /**
     * ƥץ졼ȥե
     * 
     * @access private
     * @var string
     */
    var $template_file = '';
    /**
     * ޥӥ塼ե
     * 
     * @access private
     * @var string
     */
    var $customized_view_file = '';
    /**
     * ޥӥ塼饹̾
     * 
     * @access private
     * @var string
     */
    var $customized_view_class = '';
    /**
     * 쥯ȼ᥽å̾
     * 
     * @access private
     * @var string
     */
    var $direct_method = 'getValue';
    /**
     * ץꥱ󥳥ݡͥ̾Ȥκǽ¹ԥ᥽å
     * 
     * @access private
     * @var array
     */
    var $app_components = array();
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;
    /**
     * ꥯȥ֥
     * 
     * @access private
     * @var object
     */
    var $requests = null;
    /**
     * 󥪥֥
     * 
     * @access private
     * @var object
     */
    var $action = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ȥ饪֥
     * @param object ܾ󥪥֥
     */
    function SyL_LocationManager(&$controller, &$forward)
    {
        // ̾
        $this->action_name = $forward->getActionName();
        // ǥ쥯ȥ
        $this->action_dir = $controller->getActionDir();
        // ե
        $this->action_file = $forward->getActionFile();
        // 󥯥饹̾
        $this->action_class = $forward->getClassName();
        // ǥեȥƥץ졼ȥǥ쥯ȥ
        $this->template_dir = $controller->getTemplateDir();
        // ȥ򥻥å
        $this->controller =& $controller;
    }

    /**
     * ꥯȥ֥Ȥ򥻥å
     * 
     * @access public
     * @param object ꥯȥ֥
     */
    function setRequests(&$requests)
    {
        $this->requests =& $requests;
    }

    /**
     * ꥯȥ֥Ȥ
     * 
     * @access public
     * @return object ꥯȥ֥
     */
    function &getRequests()
    {
        return $this->requests;
    }

    /**
     * ե륿ͤ
     * 
     * @access public
     * @param string ե륿̾
     * @return mixed ե륿
     */
    function getFilterValue($name)
    {
        $name = "__filter_{$name}";
        $component =& $this->_getComponent($name);
        return $component->{$this->direct_method}();
    }

    /**
     * ե륿黲Ȥͤ
     * 
     * @access public
     * @param string ե륿̾
     * @return mixed ե륿
     */
    function &getFilterValueRef($name)
    {
        $name = "__filter_{$name}";
        $component =& $this->_getComponent($name);
        return $component->{$this->direct_method}();
    }

    /**
     * ץꥱ󥳥ݡͥȤͤ
     * 
     * @access public
     * @param string ץꥱ󥳥ݡͥ̾
     * @return mixed ץꥱ󥳥ݡͥȤ
     */
    function getAppValue($name)
    {
        $component =& $this->_getComponent($name);
        return $component->{$this->direct_method}();
    }

    /**
     * ץꥱ󥳥ݡͥȤ黲Ȥͤ
     * 
     * @access public
     * @param string ץꥱ󥳥ݡͥ̾
     * @return mixed ץꥱ󥳥ݡͥȤ
     */
    function &getAppValueRef($name)
    {
        $component =& $this->_getComponent($name);
        return $component->{$this->direct_method}();
    }

    /**
     * ݡͥȤ
     * 
     * @access public
     * @param string ݡͥ̾
     * @return object ݡͥ
     */
    function &_getComponent($name)
    {
        if (!$this->controller->container->isComponent($name)) {
            trigger_error("[SyL error] Filter or AppComponent is not undefined (filter name: {$name})", E_USER_ERROR);
        }
        $component =& $this->controller->container->getComponent($name);
        if (!method_exists($component, $this->direct_method)) {
            trigger_error("[SyL error] Filter or AppComponent method is not undefined (method name: {$this->direct_method})", E_USER_ERROR);
        }
        return $component;
    }

    /**
     * ¹Ƚ򥻥å
     * 
     * @access public
     * @return bool true: ¹Ԥ롢false: ¹Ԥʤ
     */
    function setExecuteAction($is_execute_action)
    {
        $this->controller->setExecuteAction($is_execute_action);
    }

    /**
     * ץꥱ󥳥ݡͥȤ򥻥å
     * 
     * @access public
     * @param string ץꥱ󥳥ݡͥ̾
     * @param string ץꥱ󥳥ݡͥȺǽ᥽å̾
     * @param float ¹Խ
     */
    function addAppComponent($name, $method, $priority)
    {
        $name = "{$name}:{$method}";
        $this->app_components[$name] = $priority;
    }

    /**
     * 󥪥֥Ȥ򥻥å
     * 
     * @access public
     */
    function setAction()
    {
        if ($this->controller->container->isComponent(SYL_CONFIG_ACTION_NAME)) {
            $this->action =& $this->controller->container->getComponent(SYL_CONFIG_ACTION_NAME);

            // ץꥱ󥳥ݡͥȺ
            if (count($this->app_components) > 0) {
                // ¹ԽȤϵս˥
                arsort($this->app_components, SORT_NUMERIC);
                foreach ($this->app_components as $name => $method) {
                    list($name, $method) = explode(':', $name, 2);
                    if ($method != '') {
                       $component =& $this->controller->container->getComponent($name);
                       $component->{$method}();
                    }
                    $this->controller->container->deleteComponent($name);
                }
            }
        }
    }

    /**
     * 󥪥֥Ȥ¸Ƚ
     * 
     * @access public
     * @return bool true: 󥪥֥Ȥꡢfalse: 󥪥̵֥
     */
    function isAction()
    {
        return is_object($this->action);
    }

    /**
     * ƥץ졼ȥפ򥻥åȥ
     * 
     * @access public
     * @param string ƥץ졼
     */
    function setTemplateType($template_type)
    {
        $this->template_type = $template_type;
    }

    /**
     * ƥץ졼ȥפ
     * 
     * @access public
     * @return string ƥץ졼ȥ
     */
    function getTemplateType()
    {
        return $this->template_type;
    }

    /**
     * ƥץ졼ȥե򥻥å
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplateFile($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->convertPath($this->template_dir, true);
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        $template_dir  = $this->getTemplateDir();
        $template_file = $this->convertPath($this->template_file, false);
        $real_path     = @realpath($template_dir . $template_file);
        $reg           = '/^' . preg_quote($template_dir, '/') . '/';
        // ե¸ߥå
        if (!$real_path || !preg_match($reg, $real_path)) {
            SyL_Forward::redirect404();
        }
        return $template_file;
    }

    /**
     * ޥӥ塼å
     * 
     * @access public
     * @param string ޥӥ塼ե
     * @param string ޥӥ塼饹
     */
    function setCustomizedView($customized_view_file, $customized_view_class)
    {
        $this->customized_view_file  = $customized_view_file;
        $this->customized_view_class = $customized_view_class;
    }

    /**
     * ޥӥ塼ե
     * 
     * @access public
     * @return string ޥӥ塼ե
     */
    function getCustomizedViewFile()
    {
        return $this->convertPath($this->customized_view_file, false);
    }

    /**
     * ޥӥ塼饹
     * 
     * @access public
     * @return string ޥӥ塼饹
     */
    function getCustomizedViewClass()
    {
        return $this->customized_view_class;
    }

    /**
     * ѥ
     * 
     * @access public
     * @param string ѥ
     * @return string ѥ
     */
    function convertPath($path, $is_dir_path=false)
    {
        if ($is_dir_path && (substr($path, -1) != DIRECTORY_SEPARATOR)) {
            $path = $path . '/';
        } else if (!$is_dir_path && (substr($path, 0, 1) == DIRECTORY_SEPARATOR)) {
            $path = substr($path, 1);
        }
        return $path;
    }

    /**
     * ӥ塼Ϥѥ᡼
     * 
     * @access public
     * @return array ӥ塼Ϥѥ᡼
     */
    function &getValues()
    {
        $values = array();
        // åͤ
        if (SYL_TEMPLATE_COOKIE_DATA) {
            $obj =& $this->requests->getCookieObject();
            $values = array_merge($values, $obj->getParameterAll());
        }
        // åͤ
        if (SYL_TEMPLATE_SESSION_DATA) {
            $obj =& $this->requests->getSessionObject();
            $values = array_merge($values, $obj->getParameterAll());
        }
        // ꥯȥѥ᡼
        if (SYL_TEMPLATE_REQUEST_DATA) {
            $obj =& $this->requests->getParameterObject();
            $values = array_merge($values, $obj->getParameterAll());
        }

        // ѥ᡼
        if ($this->isAction()) {
            // 󥪥֥Ȥ¸ߤʥ¹ԸˤʤС
            // ץѥƥ
            foreach ($this->action as $key => $value) {
                if (substr($key, 0, 1) != '_') {
                    if (is_object($value)) {
                        $values[$key] =& $value;
                    } else {
                        $values[$key] = $value;
                    }
                }
            }
        } else {
            // 󥪥֥Ȥ¸ߤʤʥ¹̵ˤʤС
            // Υ饹ǥեȥץѥƥ
            if (!$this->controller->isExecuteAction()) {
                if (is_file($this->action_dir . $this->action_file)) {
                    include_once($this->action_dir . $this->action_file);
                    if (class_exists($this->action_class)) {
                        foreach (get_class_vars($this->action_class) as $key => $value) {
                            $values[$key] = $value;
                        }
                    }
                }
            }
        }

        return $values;
    }
}

?>
