<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loggers.php,v 1.3 2006/12/09 08:35:26 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ٥
 *
 * E_ERROR   =>  1
 * E_WARNING =>  2
 * E_NOTICE  =>  8
 * 
 *  SYL_LOG_NONE  => (̵)
 *  SYL_LOG_ERROR => SYL_LOG_ERROR 
 *  SYL_LOG_WARN  => SYL_LOG_ERROR 
 *                       SYL_LOG_WARN  
 *  SYL_LOG_NOTICE => SYL_LOG_ERROR 
 *                       SYL_LOG_WARN   
 *                       SYL_LOG_NOTICE 
 *  SYL_LOG_INFO  => SYL_LOG_ERROR 
 *                       SYL_LOG_WARN  
 *                       SYL_LOG_NOTICE 
 *                       SYL_LOG_INFO  
 *  SYL_LOG_DEBUG  => SYL_LOG_ERROR 
 *                        SYL_LOG_WARN  
 *                        SYL_LOG_NOTICE 
 *                        SYL_LOG_INFO  
 *                        SYL_LOG_DEBUG 
 */
define('SYL_LOG_NONE',   0);
define('SYL_LOG_ERROR',  E_ERROR);
define('SYL_LOG_WARN',   E_WARNING);
define('SYL_LOG_NOTICE', E_NOTICE);
define('SYL_LOG_INFO',   16);
define('SYL_LOG_DEBUG',  32);

/**
 * 饹
 */
require_once 'SyL_Logger.php';

/**
 * ϥƥꥯ饹ʣݻ륯饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loggers.php,v 1.3 2006/12/09 08:35:26 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Loggers
{
    /**
     * ƥꥪ֥ȳǼ
     * 
     * @access public
     * @var array
     */
    var $loggers = array();
    /**
     * ٥Ǽ
     * 
     * @access public
     * @var array
     */
    var $modes = array();

    /**
     * SyL_Loggers饹Υ󥹥󥹼
     *
     * singletonǥѤƤΤǡ
     * 1ĤΥ󥹥󥹤λȤ롣
     *
     * ˡ
     *   $log =& SyL_Loggers::getInstance();
     *
     * @access public
     */
    function &getInstance()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $singleton = new SyL_Loggers();
        }
        return $singleton;
    }

    /**
     * ֥ȤΥå
     * 
     * @access public
     * @param object ֥
     * @param string ƥ꥿
     */
    function setLogger(&$logger, $mode=SYL_LOG_NOTICE)
    {
        $this->loggers[] =& $logger;
        $this->modes[]   = $mode;
    }

    /**
     * νϡERROR
     *
     * @access public
     * @param string å
     */
    function error($message)
    {
        $log =& SyL_Loggers::getInstance();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_ERROR) {
                $log->loggers[$key]->log('error', $message);
            }
        }
    }

  /**
   * νϡWARN
   *
   * @access public
   * @param string å
   */
  function warn($message)
  {
        $log =& SyL_Loggers::getInstance();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_WARN) {
                $log->loggers[$key]->log('warn', $message);
            }
        }
    }

    /**
     * νϡINFO
     *
     * @access public
     * @param string å
     */
    function info($message)
    {
        $log =& SyL_Loggers::getInstance();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_INFO) {
                $log->loggers[$key]->log('info', $message);
            }
        }
    }

    /**
     * νϡDEBUG
     *
     * @access public
     * @param string å
     */
    function debug($message)
    {
        $log =& SyL_Loggers::getInstance();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_DEBUG) {
                $log->loggers[$key]->log('debug', $message);
            }
        }
    }

  /**
   * 
   *
   * @access public
   */
  function closeFinal()
  {
    foreach (array_keys($this->loggers) as $key) {
      $this->loggers[$key]->closeFinal();
    }
  }
}

?>
