<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Router.php,v 1.1 2006/12/09 08:35:26 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܾ󥯥饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Router.php,v 1.1 2006/12/09 08:35:26 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Router
{
    /**
     * ǥեȥե̾
     *
     * @access protected
     * @var string
     */
    var $action_file_default = 'index.php';
    /**
     * ĥҥȽ
     *
     * @access protected
     * @var bool
     */
    var $ext = SYL_ROUTER_EXT;
    /**
     * URLγĥ
     *
     * @access protected
     * @var string
     */
    var $url_ext = SYL_ROUTER_URL_EXT;
    /**
     * ¹ԥեγĥ
     *
     * @access protected
     * @var string
     */
    var $exe_ext = '.php';
    /**
     * PATH_INFO
     *
     * @access protected
     * @var string
     */
    var $pathinfo = array();
    /**
     * ե
     *
     * @access protected
     * @var string
     */
    var $action_file = '';
    /**
     * ̾
     *
     * @access protected
     * @var string
     */
    var $action_name = '';
    /**
     * 饹̾
     *
     * @access protected
     * @var string
     */
    var $class_name = '';

    /**
     * եɥ롼
     *
     * @static
     * @access public
     * @param object ꥯȥ֥
     * @param string 襪֥̾
     * @return object 襪֥
     */
    function &getObject(&$requests, $rule)
    {
        $class_name = 'SyL_Router' . ucfirst($rule);
        include_once SYL_INCLUDE_DIR . "/framework/Router/{$class_name}.php";
        $obj =& new $class_name($requests->getParameterObject());
        return $obj;
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getActionName()
    {
        return $this->action_name;
    }

    /**
     * ե
     *
     * @access public
     * @return string ե
     */
    function getActionFile()
    {
        return $this->action_file;
    }

    /**
     * 饹̾
     *
     * @access public
     * @return string 饹ե
     */
    function getClassName()
    {
        return $this->class_name;
    }

    /**
     * PATH_INFO
     *
     * @access public
     * @return array PATH_INFO
     */
    function getPathInfoArray()
    {
        return $this->pathinfo;
    }

    /**
     * URL˥å
     *
     * @access public
     * @param string URL
     */
    function setSyLSelf($syl_self)
    {
        define('SYL_SELF', $syl_self);
    }

    /**
     * ǥ쥯ȥȥСб
     *
     * @access public
     * @param string ѥ
     * @return bool true: OKfalse: 顼
     */
    function isInvalidPath($pathinfo)
    {
        return preg_match('/\.\.\//', preg_quote($pathinfo, '/'));
    }

    /**
     * 404 Not Found ˥쥯Ȥ
     *
     * @access public
     * @param string URL
     */
    function redirect404()
    {
        $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
        SyL_Loggers::info("[Router] 404 Not Found - {$request_uri}");

        header("HTTP/1.0 404 Not Found");
        if (defined('SYL_ROUTER_URL_404') && SYL_ROUTER_URL_404) {
            header('Location: ' . SYL_ROUTER_URL_404);
            exit;
        } else {
            exit("HTTP/1.0 404 Not Found");
        }
    }


}

?>
