<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewSmarty.php,v 1.3 2006/12/09 08:35:26 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Smarty饹
 */
require_once SYL_SMARTY_DIR . 'Smarty.class.php';
/**
 * ɽ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_View.php';

/**
 * Smartyɽ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewSmarty.php,v 1.3 2006/12/09 08:35:26 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewSmarty extends SyL_View
{
    /**
     * Smarty֥
     * 
     * @var object
     */
    var $smarty = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewSmarty()
    {
        $this->smarty =& new Smarty();
        $this->smarty->compile_dir = SYL_SMARTY_COMPILE_DIR;
        $this->smarty->config_dir  = SYL_SMARTY_CONFIG_DIR;
        $this->smarty->cache_dir   = SYL_SMARTY_CACHE_DIR;
    }

    /**
     * ƥץ졼ɽ
     * 
     * @access public
     */
    function render()
    {
        // ƥץ졼ȥǥ쥯ȥꥻå
        $this->smarty->template_dir = $this->lm->getTemplateDir();
        // 󤫤Υѥ᡼
        foreach ($this->lm->getValues() as $key => $value) {
            if (is_object($value)) {
                $this->smarty->assign_by_ref($key, $value);
            } else {
                $this->smarty->assign($key, $value);
            }
        }
        $this->smarty->display($this->lm->getTemplateFile());
    }
}

?>
