<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB.php,v 1.3 2006/12/09 08:35:25 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ǥХåե饰
 * trueξ¹SQL˽񤭹
 */
define( 'DB_DEBUG', false );

/**
 *  DB饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB.php,v 1.3 2006/12/09 08:35:25 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DB
{
    /**
     * 󥹥DB̾
     * 
     * @access protected
     * @var string
     */
    var $dbname = '';
    /**
     * ͥ꥽
     * 
     * @access protected
     * @var resource
     */
    var $connection = null;
    /**
     * ȥ󥶥ե饰
     * 
     * @access protected
     * @var boolean
     */
    var $transaction = false;
    /**
     * 饤ȥ󥳡
     * 
     * @access protected
     * @var string
     */
    var $client_encode = '';
    /**
     * С󥳡
     * 
     * @access protected
     * @var string
     */
    var $server_encode = '';
    /**
     * ֥
     * 
     * @access protected
     * @var object
     */
    var $log = null;

    /**
     * ե򻲾Ȥ
     * ե̾ʸʸ컲ȥե饰
     *
     * MistaleϡCASE_UPPERΤб
     * 
     * @access protected
     * @var string ʸ: CASE_UPPER
     *             ʸ: CASE_LOWER
     *             Τޤ  : ʶʸ
     */
    // var $field_ref = '';
    var $field_ref = CASE_UPPER;

    /**
     * tigger_errorȯե饰
     * 
     * @access protected
     * @var bool
     */
    var $trigger_error_flag = true;
    /**
     * ǽ顼å
     * 
     * @access protected
     * @var string ǽ顼å
     */
    var $db_last_error = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string Db
     * @param string 饤ȥ󥳡
     * @param string С󥳡
     */
    function SyL_DB($dbtype, $client_encode, $server_encode)
    {
        set_magic_quotes_runtime(0);
        $this->dbname = $dbtype;
        $this->client_encode = $client_encode;
        $this->server_encode = $server_encode;
    }

    /**
     * SyL_DB饹Υ󥹥󥹼
     *
     * ˡ
     *   $db =& SyL_DB::getInstance();
     *
     * $dsn = '[dbtype]:dbname=[dbname];host=[hostname];port=[port];user=[username];passwd=[password]';
     * $options = array(
     *   'persistent'    => bool,
     *   'client_encode' => string,
     *   'server_encode' => string
     * );
     *
     *
     * @access public
     * @param string ³ʸ
     */
    function &getConnection($dsn)
    {
        static $singleton = array();
        if (!isset($singleton[$dsn])) {
            $tmp = explode( ':', $dsn, 2 );
            $dbtype = ucfirst($tmp[0]);
            $dbname = '';
            $user   = '';
            $passwd = '';
            $host   = '';
            $port   = '';
            $persistent    = '';
            $client_encode = '';
            $server_encode = '';
            if (isset($tmp[1])) {
                $tmp = explode(';', $tmp[1]);
                foreach ($tmp as $tmp2) {
                    list($name, $value) = explode('=', $tmp2, 2);
                    $$name = $value;
                }
            }

            $class_name = 'SyL_DB_' . $dbtype;
            // ¥󥹥󥹺
            include_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'DB' . DIRECTORY_SEPARATOR . $class_name . '.php';
            $singleton[$dsn] = new $class_name($dbtype, $client_encode, $server_encode);
            $singleton[$dsn]->openConnection($dbname, $user, $passwd, $host, $port, $persistent);
        }
        return $singleton[$dsn];
    }

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param string ³Ū³Ԥ
     @ @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        trigger_error( "[SyL error] openConnection method not found ({$dbname})", E_USER_ERROR );
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection() {}

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string ʸ
     */
    function setClientEncoding($client_encode)
    {
        $this->client_encode = $client_encode;
    }

    /**
     * С¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string ʸ
     */
    function setServerEncoding($server_encode)
    {
        $this->server_encode = $server_encode;
    }

    /**
     * ѥ᡼ͤˤꥯȤʸ
     * ˥¹Ԥ
     *
     * @access public
     * @param string ʸ
     * @return string ȸʸ
     */
    function quote($value)
    {
        if (($value === '') || ($value === null)) {
            return 'NULL';
        } else if (is_int($value) || is_float($value)) {
            return $value;
        } else {
            return "'" . $this->sanitize($value) . "'";
        }
    }

    /**
     * SQLʸ
     * ˥¹Ԥ
     *
     * @access public
     * @param string ǡ
     * @return string SQLʸ
     */
    function condition($value)
    {
        $value = $this->quote($value);
        if ($value == 'NULL') {
            $value = ' IS ' . $value . ' ';
        } else {
            $value = ' = ' . $value . ' ';
        }
        return $value;
    }
  
    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     *
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function sanitize($parameter)
    {
        return (!is_numeric($parameter) ? addslashes($parameter) : $parameter);
    }

    /**
     * ѥ᡼˥̵˽Likeʸ
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function sanitizeLike($parameter)
    {
        return preg_replace('/(\_|\%)/', '\\\\$1', $parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function begin()
    {
        // SQL¸
        $this->setLog('begin');
  
        if (class_exists('SyL_Error')) {
            $e =& SyL_Error::getInstance();
            $e->resetErrorHandler();
        }
        $this->transaction = true;
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollback()
    {
        // SQL¸
        $this->setLog('rollback');

        if (class_exists('SyL_Error')) {
            $e =& SyL_Error::getInstance();
            $e->setErrorHandler();
        }
        $this->transaction = false;
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
      // SQL¸
      $this->setLog('commit');

      if (class_exists('SyL_Error')) {
          $e =& SyL_Error::getInstance();
          $e->setErrorHandler();
      }
      $this->transaction = false;
  }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execute($sql, &$result)
    {
        // SQL¸
        $this->setLog($sql);

        // ᥽å̾
        list($method) = explode( ' ', $sql, 2 );

        // SQL¹
        $result = false;
        switch (strtolower($method)) {
        case 'select':
            $result = $this->executeSelect($sql);
            break;
        case 'insert':
        case 'update':
        case 'delete':
            $result = $this->executeUpdate($sql);
            break;
        default:
            $result = $this->executeNoReturn($sql);
            break;
        }
        return ($result === false) ? false : true;
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     *
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function &executeSelect( $sql )
    {
        trigger_error("[SyL error] executeSelect method not found ({$dbname})", E_USER_ERROR);
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     *
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function executeUpdate( $sql )
    {
        trigger_error("[SyL error] executeUpdate method not found ({$dbname})", E_USER_ERROR);
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     *
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeNoReturn( $sql )
    {
        trigger_error("[SyL error] executeNoReturn method is not found ({$dbname})", E_USER_ERROR);
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     *
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeGet( $sql, &$data, $get='all' ) {}

    /**
     * SQL¹Ԥڡ˥ǡ
     * ¹ˡinitializePageץ᥽åɼ¹ɬ
     * SQLʸΡFROM׶ľ˥ʸɬܡʤʳΥʸԲġ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function executePage($sql, &$result, &$page_control, $limit, $page=1) {}

    /**
     * Υѥ᡼ˡSQLDMLˤȤΩƼ¹Ԥ
     * ˥⼫ưǹԤ
     * ѿǻꤹʳϡȽꤵ롣
     *
     * array(
     *  'name'     => $name,
     *  'address'  => $adress,
     *  'datetime' => array('function' => 'current_timestamp'),
     *  'id'       => array('number' => 1),
     *  'IS_NULL'  => array('null' => ''),
     *  ...
     * );
     *
     * @access public
     * @param string ơ֥̾
     * @param array ȤΥǡ
     * @param string insert or update or delete
     * @param string ѥ᡼update, deleteΤߡ
     * @return bool ¹Է true: OKfalse: 顼
     */
    function executePerform($table, $columns, $action='insert', $where='')
    {
        switch (strtolower($action)) {
        case 'insert':
            $field = array();
            $data  = array();
            foreach ($columns as $column => $value) {
                $field[] = $column;
                if (is_array($value)) {
                    list($attribute, $value) = each($value);
                    if ((strtolower($attribute) === 'null') || ($value === null) || ($value === '')) {
                        $data[] = "NULL";
                    } else {
                        switch (strtolower($attribute)) {
                        case 'function':
                        case 'number':
                            $data[] = $value;
                            break;
                        default:
                            $data[] = $this->quote($value);
                            break;
                        }
                    }
                } else {
                    $data[] = $this->quote($value);
                }
            }
            // SQL INSERT
            $sql = "INSERT INTO " . $table . " (" . implode(',', $field) . ") VALUES (" . implode(',', $data) . ")";
            break;

        case 'update':
            $update = array();
            foreach ($columns as $column => $value) {
                if (is_array($value)) {
                    list($attribute, $value) = each($value);
                    if ((strtolower($attribute) === 'null') || ($value === null) || ($value === '')) {
                        $update[] = $column . " = NULL";
                    } else {
                        switch (strtolower($attribute)) {
                        case 'function':
                        case 'number':
                            $update[] = $column . " = " . $value;
                            break;
                        default:
                            $update[] = $column . " = " . $this->quote($value);
                            break;
                        }
                    }
                } else {
                    $update[] = $column . " = " . $this->quote($value);
                }
            }
      
            if ($where != '') {
                $where = "WHERE " . $where;
            }
            // SQL UPDATE
            $sql = "UPDATE " . $table . " SET " . implode(',', $update) . " " . $where;
            break;

        case 'delete':
            if ($where != '') {
                $where = "WHERE " . $where;
            }
            // SQL DELETE
            $sql = "DELETE FROM " . $table . " " . $where;

        default:
          trigger_error("[SyL error] executePerform method is insert or update only", E_USER_ERROR);
        }

        return $this->execute($sql, $num);
    }


    /**
     * SyLȥɥץ㥪֥Ȥ
     *
     * @access public
     * @param string ȥɥץ̾
     * @return object SyLȥɥץ㥪֥
     */
    function &getProcedureObject( $procedure_name )
    {
        $classname = 'SyL_DB_' . $this->dbname . '_Procedure';
        include_once( $classname . '.php' );
        return (new $classname( $this->connection, $procedure_name, $this->transaction ));
    }
  
    /**
     * ȥꥬ顼ưǵưʤ褦
     *
     * @access public
     * @param boolean true: ȥꥬ顼ONfalse: ȥꥬ顼OFF
     */
    function setTriggerError($trigger_error_flag)
    {
        $this->trigger_error_flag = ($trigger_error_flag === true);
    }

    /**
     * trigger_errorȯư
     * ȥ󥶥ȯưʤ
     *
     * @access public
     * @param string 顼å
     */
    function trigger_error_db($error_message)
    {
        if (($this->transaction) || (!$this->trigger_error_flag)) {
            $this->db_last_error = $error_message;
        } else {
            trigger_error($error_message, E_USER_ERROR);
        }
    }

    /**
     * Ǹ˵ä顼å
     *
     * @access public
     * @return string Ǹ˵ä顼å
     */
    function getLastErrorMessage()
    {
        return $this->db_last_error;
    }

    /**
     * ̥åΥե̾ʸޤϾʸȤˤ
     *
     * @access public
     * @return array Ѵ
     * @return array Ѵ
     */
    function changeFieldName($record)
    {
        if (is_array($record) && ($this->field_ref != '')) {
            return array_change_key_case($record, $this->field_ref);
        } else {
            return $record;
        }
    }

    /**
     * SQL¸
     *
     * @access public
     * @param string SQLʸ
     */
    function setLog($sql)
    {
        if (is_object($this->log)) {
            $this->log->debug($sql);
        }
    }

    /**
     * DB饹̾
     *
     * @access public
     * @return string DB饹̾
     */
    function getDBName()
    {
        return $this->dbname;
    }

    /**
     * ƥռؿ̾
     *
     * @access public
     * @return string ƥռؿ̾
     */
    function getSqlSystemDate()
    {
        return 'CURRENT_TIMESTAMP';
    }

    /**
     * եեޥåȴؿ̾
     *
     * @access public
     *
     * @param string ̾
     * @param string շեޥå
     * @return string եեޥåȴؿ̾
     */
    function getSqlDateFormat($column_name, $format) {}

    /**
     * ơ֥
     *
     * @access public
     *
     * @return array ơ֥ꥹ
     */
    function getTableList()
    {
        return array();
    }

    /**
     * 
     *
     * @access public
     *
     * @param string ơ֥̾
     * @return array ꥹ
     */
    function getColumnList( $table_name )
    {
        return array();
    }
}

?>
