<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XMLParser.php,v 1.3 2006/12/09 08:35:25 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  XMLѡ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XMLParser.php,v 1.3 2006/12/09 08:35:25 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XMLParser
{
    /**
     * եѥURLǤOK
     *
     * @access private
     * @var string
     */
    var $file_name = '';
    /**
     * ե륵
     *
     * @access private
     * @var string
     */
    var $file_size = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XMLե̾
     */
    function SyL_XMLParser($file_name)
    {
        $this->file_name = $file_name;
        if (file_exists($this->file_name)) {
            $this->setStreamSize(filesize($this->file_name));
        }
    }

    /**
     * ȥ꡼򥻥å
     *
     * @access public
     * @param int ȥ꡼
     */
    function setStreamSize( $file_size )
    {
        $this->file_size = $file_size;
    }

    /**
     * XMLեβϽ
     *
     * @access private
     */
    function parseXML()
    {
        if ($this->file_name == '') {
            trigger_error( "[SyL error] Xml file not found ({$this->file_name})", E_USER_ERROR );
        }
        if ($this->file_size == '') {
            trigger_error( "[SyL error] Xml file size invalid ({$this->file_name})", E_USER_ERROR );
        }

        // XMLѡ ʸUTF-8
        $xmlParser = xml_parser_create( 'UTF-8' );
        // ʸѴԤʤ
        xml_parser_set_option( $xmlParser, XML_OPTION_CASE_FOLDING, false );
        // ϥɥ᥽åɤ򥯥饹᥽åɤ
        xml_set_object( $xmlParser, &$this );
        // start  end ǤΥϥɥꤹ
        xml_set_element_handler( $xmlParser,
          array( &$this, 'startElement' ),
          array( &$this, 'endElement'   )
        );
        // ʸǡϥɥꤹ
        xml_set_character_data_handler( $xmlParser, array( &$this, 'characters' ) );

        // XMLե륪ץ
        if (($fp = @fopen( $this->file_name, 'r' )) == false) {
            trigger_error( "Can't open xml file(" . $this->file_name . ").", E_USER_ERROR );
        } else {
            // ɤ߹ߤȲ
            while ($data = fread($fp, $this->file_size)) {
                // XMLѡ
                if (!xml_parse( $xmlParser, $data, feof($fp) )){
                    // ѡ顼
                    trigger_error(
                      sprintf( "XML parse error: %s at %s(%d).",
                        xml_error_string(xml_get_error_code($xmlParser)),
                        $this->file_name,
                        xml_get_current_line_number($xmlParser)
                      ),
                      E_USER_ERROR
                    );
                }
            }
            // XMLե륯
            fclose( $fp );
        }
        // XMLѡγ 
        xml_parser_free( $xmlParser );
    }

    /**
     * ȳϤμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     * @param array Ȥ°
     */
    function startElement(&$parser, $name, $attr) {}

    /**
     * Ƚλμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     */
    function endElement(&$parser, $name) {}

    /**
     * 饯Ȥμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ʸ
     */
    function characters(&$parser, $text) {}
}

?>
