<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Requests.php,v 1.4 2006/12/11 11:59:42 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * p[^ێNX𕡐ێNX
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Requests.php,v 1.4 2006/12/11 11:59:42 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Requests
{
    /**
     * NGXgp[^IuWFNg
     * 
     * @access private
     * @var object
     */
    var $parameter = null;
    /**
     * ZbVIuWFNg
     * 
     * @access private
     * @var object
     */
    var $session = null;
    /**
     * NbL[IuWFNg
     * 
     * @access private
     * @var object
     */
    var $cookie = null;
    /**
     * t@CIuWFNg
     * 
     * @access private
     * @var object
     */
    var $files = null;

    /**
     * RXgN^
     *
     * @access public
     */
    function SyL_Requests()
    {
        // NGXgp[^IuWFNg쐬
        $this->createParameter();
        // t@CAbv[h́At@CAbv[hIuWFNg쐬
        if (isset($_SERVER['CONTENT_TYPE']) && preg_match('|multipart/form\-data|', $_SERVER['CONTENT_TYPE'])) {
            $this->createFile();
        }
    }

    /**
     * SyL_RequestsNX̃CX^X擾
     *
     * singletonf̗pĂ̂ŁA
     * 1̃CX^X̎QƂ擾B
     *
     * 擾@
     *   $SyL_Requests =& SyL_Requests::getInstance();
     *
     * @access public
     */
    function &getInstance()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $classname = __CLASS__;
            $singleton = new $classname();
        }
        return $singleton;
    }

    /**
     * NGXgp[^IuWFNg쐬
     *
     * @access private
     */
     function createParameter()
     {
         if ($this->parameter == null) {
             include_once SYL_INCLUDE_DIR . '/framework/Request/SyL_RequestParameter.php';
             $this->parameter =& new SyL_RequestParameter();
         }
     }

    /**
     * ZbVIuWFNg쐬
     *
     * @access private
     */
     function createSession()
     {
         if ($this->session == null) {
             include_once SYL_INCLUDE_DIR . '/framework/Request/SyL_RequestSession.php';
             $this->session =& new SyL_RequestSession();
         }
     }

    /**
     * NbL[IuWFNg쐬
     *
     * @access private
     */
     function createCookie()
     {
         if ($this->cookie == null) {
             include_once SYL_INCLUDE_DIR . '/framework/Request/SyL_RequestCookie.php';
             $this->cookie =& new SyL_RequestCookie();
         }
     }

    /**
     * Abv[ht@CIuWFNg쐬
     *
     * @access private
     */
     function createFile()
     {
         if ($this->files == null) {
             include_once SYL_INCLUDE_DIR . '/framework/Request/SyL_RequestFile.php';
             $this->files =& new SyL_RequestFile();
         }
     }

    /**
     * p[^Zbg
     * 
     * @access public
     * @param string p[^
     * @param string p[^l
     */
    function setParameter($name, $value)
    {
        $this->parameter->setParameter($name, $value);
    }

    /**
     * NGXgl擾
     *
     * @access public
     * @param string p[^
     * @return mixed p[^l
     */
    function getParameter($name)
    {
        return $this->parameter->getParameter($name);
    }

    /**
     * NGXgIuWFNg擾
     *
     * @access public
     * @return array p[^l
     */
    function &getParameterObject()
    {
        return $this->parameter;
    }

    /**
     * ZbVlZbg
     * 
     * @access public
     * @param string p[^
     * @param string p[^l
     */
    function setSession($name, $value)
    {
        if ($this->session == null) {
            $this->createSession();
        }
        $this->session->setParameter($name, $value);
    }

    /**
     * ZbVl擾
     *
     * @access public
     * @param string p[^
     * @return mixed p[^l
     */
    function getSession($name)
    {
        if ($this->session == null) {
            $this->createSession();
        }
        return (($this->session != null) ? $this->session->getParameter($name) : null);
    }

    /**
     * ZbVIuWFNg擾
     *
     * @access public
     * @return array p[^l
     */
    function &getSessionObject()
    {
        if ($this->session == null) {
            $this->createSession();
        }
        return $this->session;
    }

    /**
     * NbL[lZbg
     * 
     * @access public
     * @param string p[^
     * @param string p[^l
     */
    function setCookie($name, $value)
    {
        if ($this->cookie == null) {
            $this->createCookie();
        }
        $this->cookie->setParameter($name, $value);
    }

    /**
     * NbL[l擾
     *
     * @access public
     * @param string p[^
     * @return mixed p[^l
     */
    function getCookie($name)
    {
        if ($this->cookie == null) {
            $this->createCookie();
        }
        return $this->cookie->getParameter($name);
    }

    /**
     * NbL[IuWFNg擾
     *
     * @access public
     * @return array p[^l
     */
    function &getCookieObject()
    {
        if ($this->cookie == null) {
            $this->createCookie();
        }
        return $this->cookie;
    }

    /**
     * Abv[ht@Cl擾
     *
     * @access public
     * @param string p[^
     * @return mixed p[^l
     */
    function getFile($name)
    {
        if ($this->files == null) {
            trigger_error("[SyL error] Upload File Object Not Found", E_USER_ERROR);
        }
        return $this->files->getParameter($name);
    }

    /**
     * Abv[ht@CIuWFNg擾
     *
     * @access public
     * @return array p[^l
     */
    function &getFileObject()
    {
        if ($this->files == null) {
            trigger_error("[SyL error] Upload File Object Not Found", E_USER_ERROR);
        }
        return $this->files;
    }

}

?>
