<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Validator.php,v 1.4 2006/12/11 11:59:19 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڸ̥饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Validator.php,v 1.4 2006/12/11 11:59:19 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Validator extends SyL_Validation
{
    /**
     * ڥ
     *
     * @access protected
     * @var string
     */
    var $type = '';
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string 顼åΥեޥå
     * @param array ڥѥ᡼
     */
    function SyL_Validator($error_message, $parameters=array())
    {
        $this->error_message = $error_message;
        $this->parameters    = array_merge($this->parameters, $parameters);
        if (preg_match('/^syl_validator(.+)$/', strtolower(get_class($this)), $matches)) {
            $this->type = strtolower($matches[1]);
        }
    }

    /**
     * ̸ڥ֥Ȥμ
     *
     * @access public
     * @param string ̾
     * @param string о
     */
    function &create($validate_name, $error_message, $parameters=array())
    {
        $validate_name = ucfirst($validate_name);
        $class_name =  'SyL_Validator' . $validate_name;
        include_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Validator' . DIRECTORY_SEPARATOR . $class_name . '.php';
        $obj =& new $class_name($error_message, $parameters);
        return $obj;
    }

    /**
     * ڥѥ᡼򥻥å
     *
     * @access public
     * @param array ڥѥ᡼
     */
    function setParameters($parameters)
    {
        $this->parameters = array_merge($this->parameters, $parameters);
    }

    /**
     * ¨ڽ¹Ԥ
     *
     * @access public
     * @param string ̾
     * @param string о
     * @param array ڥѥ᡼
     * @return bool true: 顼̵, false: 顼
     */
    function check($validate_name, $value, $parameters=array())
    {
        $validator =& SyL_Validator::create($validate_name, '', $parameters);
        return $validator->execute($value);
    }

    /**
     * ڽ¹Ԥ
     * ҥ饹˥ѥ᡼̾Ʊڥ᥽åɤ
     *
     * @access public
     * @param string о
     * @return bool true: 顼̵, false: 顼
     */
    function execute($value)
    {
        // ɬܥå or եåʳǡͤξtrue
        if (!preg_match('/^SyL_Validator(Requires?)(.*)$/i', get_class($this))) {
            // ѿʤ      => SyL_ValidatorRequire
            // 1ʤ => SyL_ValidatorRequires
            // 2ʤ => SyL_ValidatorRequiresFile
            // ...
            if (is_array($value)) {
                $func = is_array(current($value)) ? 'requiresfile' : 'requires';
            } else {
                $func = 'require';
            }
            if (!SyL_Validator::check($func, $value)) {
                return true;
            }
        }

        return call_user_func(array(&$this, 'validate'), $value);
    }

    /**
     * ɬܸڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @param array ȥѥ᡼
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        trigger_error("[SyL error] 'validate' method is not implemented in this class(" . get_class($this) . ")");
    }
}

?>
