<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementFile.php,v 1.5 2006/12/16 19:07:28 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եϥեǥ饹
 *
 * ̾ : ̾ : ̾(name) : (value)
 *   1  :      -     :    1         :   1
 *
 * 󥹥󥹺ˡ
 * // 쥯饹饹ƥå᥽åɤǼ
 * $element = SyL_FormElement::create( 'text', 'name', '̾' );
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementFile.php,v 1.5 2006/12/16 19:07:28 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementFile extends SyL_FormElement
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string եHTML̾
     * @param string եɽ̾
     * @param string եǤ
     * @param array եǤradio, select, checkboxξΤߡ
     * @param string եǤɲ°
     */
    function SyL_FormElementFile($name, $display_name, $options=array(), $value=null, $attributes=array())
    {
        $this->type         = 'file';
        $this->name         = $name;
        $this->display_name = $display_name;
        // ǥեͤμ
        $this->value     = ($value === null) ? $this->getParameter() : $value;
        $this->attributes = array_merge($this->attributes, $attributes);
    }

    /**
     * ꥯȤͤ
     * С饤
     *
     * @access public
     * @param string եHTML̾
     * @return mixed ꥯѿ
     */
    function getParameter($name)
    {
        $value = isset($_FILES[$name]) ? $_FILES[$name] : '';
        return $value;
    }

    /**
     * եHTMLϡϹܡ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
        $html_element  = '';
        $html_element .= '<input ';
        $html_element .=   'type="'  . $this->type      . '" ';
        $html_element .=   'name="'  . $this->name . '[]" ';
        $html_element .=   'value="" ';
        $html_element .= $this->getAttribute();
        $html_element .= '>';

        return $html_element;
    }

    /**
     * եHTMLϡɽ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
        return $this->encodeHtml(implode('/', $this->value['name']));
    }

    /**
     * JavaScriptϥå
     * С饤
     *
     * @access public
     * @return string JavaScriptϥå
     */
    function getJavaScript()
    {
        if (is_object($this->validators)) {
            $js  = '';
            $js .= 'var error_flag = false;' . "\r\n";
            $js .= 'var element_name = "' . $this->getName() . '[]";' . "\r\n";
            $js .= $this->validators->getJavaScript($this->getDisplayName(), $this->options);
            $js .= "\r\n";
            return $js;
        } else {
            return '';
        }
    }
}


?>
