<?php
/**
 * ץȺ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: project.php,v 1.1 2006/12/16 19:06:16 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Project
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function Project()
    {
    }

    /**
     * ɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     * @param object ݡͥȥ᥽åɥ֥
     */
    function execute(&$cmd, &$cm)
    {
        $project_dir     = $cmd->getArg('-d');
        $app_name        = $cmd->getArg('-w');
        $controller_file = $cmd->getArg('-c');
        $action_files    = $cmd->getArg('-a');
        $template_files  = $cmd->getArg('-t');

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        $cnt = count($project_dir);
        if ($cnt == 0) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Project directory (-d) only 1", E_USER_ERROR);
            exit;
        }

        $project_dir = preg_match('/(\\\\|\/)$/', $project_dir[0]) ? $project_dir[0] : $project_dir[0] . '/';

        if (file_exists($project_dir)) {
            if (!is_writable($project_dir)) {
                trigger_error("[SyL error] Project directory permission denied ({$project_dir})", E_USER_ERROR);
                exit;
            }
            if ($cmd->getInput('', "create project ({$project_dir}) [Y/n]:") != 'Y') {
                exit;
            }
        } else {
            if ($cmd->getInput('', "create directory ({$project_dir}) [Y/n]:") != 'Y') {
                exit;
            }
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $cnt = count($app_name);
        if ($cnt == 0) {
            $app_name = '';
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Application name (-w) only 1", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name[0])) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        } else {
            $app_name = $app_name[0];
        }

        // -------------------------------------------------
        // ȥեå
        // -------------------------------------------------
        $cnt = count($controller_file);
        if ($cnt == 0) {
            $controller_file = '';
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Controller file (-c) only 1", E_USER_ERROR);
            exit;
        } else {
            $controller_file = $controller_file[0];
        }

        if ($controller_file) {
            if ($app_name == '') {
                trigger_error("[SyL error] Application name not found for create controller", E_USER_ERROR);
                exit;
            } else if (file_exists($controller_file)) {
                if ($cmd->getInput('Already controller file exists', "overwrite controller file ({$controller_file}) [Y/n]:") != 'Y') {
                    exit;
                }
                if (!is_writable($controller_file)) {
                    trigger_error("[SyL error] Create controller file permission denied ({$controller_file})", E_USER_ERROR);
                    exit;
                }
            } else {
                if (!is_writable(dirname($controller_file))) {
                    trigger_error("[SyL error] Create controller file permission denied ({$controller_file})", E_USER_ERROR);
                    exit;
                }
            }
        }

        // -------------------------------------------------
        // եå
        // -------------------------------------------------
        $action_dir = $project_dir . 'app/' . $app_name . '/actions/';
        $cnt = count($action_files);
        if ($cnt == 0) {
            $action_files = array();
        }

        if (count($action_files) > 0) {
            if ($app_name == '') {
                trigger_error("[SyL error] Application name not found for create action", E_USER_ERROR);
                exit;
            } else {
                foreach ($action_files as $action_file) {
                    if (!preg_match('/^(\\\\|\/)/', $action_file)) {
                        $action_file = '/' . $action_file;
                    }
                    if (substr($action_file, -4) != '.php') {
                        $action_file .= '.php';
                    }
                    if (file_exists($action_dir . $action_file)) {
                        trigger_error("[SyL error] Already action file exists ({$action_dir}{$action_file})", E_USER_ERROR);
                        exit;
                    }
                }
            }
        }

        // -------------------------------------------------
        // ƥץ졼ȥեå
        // -------------------------------------------------
        $template_dir = $project_dir . 'app/' . $app_name . '/templates/';
        $cnt = count($template_files);
        if ($cnt == 0) {
            $template_files = array();
        }

        if (count($template_files) > 0) {
            if ($app_name == '') {
                trigger_error("[SyL error] Application name not found for create template", E_USER_ERROR);
                exit;
            } else {
                foreach ($template_files as $template_file) {
                    if (!preg_match('/^(\\\\|\/)/', $template_file)) {
                        $template_file = '/' . $template_file;
                    }
                    if (substr($template_file, -5) != '.html') {
                        $template_file .= '.html';
                    }
                    if (file_exists($template_dir . $template_file)) {
                        trigger_error("[SyL error] Already template file exists ({$template_dir}{$template_file})", E_USER_ERROR);
                        exit;
                    }
                }
            }
        }

        // -------------------------------------------------
        // ץȺ
        // -------------------------------------------------
        $cm->triggerApp('c_project', $project_dir);

        // -------------------------------------------------
        // ץꥱ
        // -------------------------------------------------
        if ($app_name) {
            $cm->triggerApp('c_application', $project_dir, $app_name);
        }

        // -------------------------------------------------
        // ȥե
        // -------------------------------------------------
        if ($controller_file) {
            $cm->triggerApp('c_controller', $project_dir, $app_name, $controller_file);
        }

        // -------------------------------------------------
        // ե
        // -------------------------------------------------
        if (count($action_files) > 0) {
            $cm->triggerApp('c_action', $project_dir, $app_name, $action_files);
        }

        // -------------------------------------------------
        // ƥץ졼ȥե
        // -------------------------------------------------
        if (count($template_files) > 0) {
            $cm->triggerApp('c_template', $project_dir, $app_name, $template_files);
        }
    }

}

?>
